/*
 * Copyright (c) 2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core;

import java.util.List;
import java.util.Set;

public interface TextAnimator extends Expressionee {

	boolean isEnabled();

	void setEnabled(boolean enabled);

	String getName();

	void setName(String name);


	List<TASelector> getSelectors();

	Set<TAProperty> getProperties();

	AnimatableVec3d getAnchorPoint();

	AnimatableVec3d getPosition();

	AnimatableVec3d getScale();

	AnimatableDouble getSkew();

	AnimatableDouble getSkewAxis();

	AnimatableDouble getRotationX();

	AnimatableDouble getRotationY();

	AnimatableDouble getRotationZ();

	AnimatableDouble getOpacity();

	AnimatableColor getFillRGB();

	AnimatableDouble getFillHue();

	AnimatableDouble getFillSaturation();

	AnimatableDouble getFillLuminosity();

	AnimatableDouble getFillOpacity();

	AnimatableColor getStrokeRGB();

	AnimatableDouble getStrokeHue();

	AnimatableDouble getStrokeSaturation();

	AnimatableDouble getStrokeLuminosity();

	AnimatableDouble getStrokeOpacity();

	AnimatableDouble getStrokeWidth();

	AnimatableDouble getTracking();

	AnimatableVec2d getLineSpacing();

	AnimatableEnum<CharacterRange> getCharacterRange();

	AnimatableInteger getCharacterValue();

	AnimatableInteger getCharacterOffset();

	AnimatableVec2d getBlur();


	void prepareExpression(ExpressionScope scope);


	public enum AnchorPointGrouping {
		CHARACTER,
		WORD,
		LINE,
		ALL
	}

	public enum CharacterAlignment {
		LEFT_OR_TOP,
		CENTER,
		RIGHT_OR_BOTTOM,
		ADJUST_KERNING
	}

	public enum CharacterRange {
		GROUP,
		FULL
	}

}
