/*
 * Copyright (c) 2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.effects;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableString;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.Effect.Categories;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.core.services.QCIntegrationSupport;

import com.google.inject.Inject;

@Effect(id="ch.kuramo.javie.QCBooleanControl", category=Categories.QUARTZ_COMPOSER_CONTROLS)
public class QCBooleanControl {

	@Property
	private IAnimatableString key;

	@Property
	private IAnimatableBoolean value;


	private final IVideoEffectContext context;

	private final QCIntegrationSupport qciSupport;

	@Inject
	public QCBooleanControl(IVideoEffectContext context, QCIntegrationSupport qciSupport) {
		this.context = context;
		this.qciSupport = qciSupport;
	}

	public IVideoBuffer doVideoEffect() {
		qciSupport.setValueForInputKey(context.value(key), context.value(value));
		return context.doPreviousEffect();
	}

}
