/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.core.AbstractLayer;
import ch.kuramo.javie.core.AnimatableColor;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.AnimatableVec3d;
import ch.kuramo.javie.core.CoreContext;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.LightLayer;
import ch.kuramo.javie.core.LightType;
import ch.kuramo.javie.core.annotations.ProjectElement;

@ProjectElement("lightLayer")
public class LightLayerImpl extends AbstractLayer implements LightLayer {

	private boolean videoEnabled = true;

	private AnimatableVec3d pointOfInterest = new AnimatableVec3d(new Vec3d(0, 0, 0));

	private AnimatableVec3d position = new AnimatableVec3d(new Vec3d(0, 0, 0));

	private AnimatableVec3d orientation = new AnimatableVec3d(new Vec3d(0, 0, 0), true);

	private AnimatableDouble rotationX = new AnimatableDouble(0d);

	private AnimatableDouble rotationY = new AnimatableDouble(0d);

	private AnimatableDouble rotationZ = new AnimatableDouble(0d);

	private LightType lightType = LightType.POINT;

	private AnimatableDouble intensity = new AnimatableDouble(100d);

	private AnimatableVec3d attenuation = new AnimatableVec3d(new Vec3d(1, 0, 0), Vec3d.ZERO, Vec3d.POSITIVE_INFINITY);

	private AnimatableColor color = new AnimatableColor(Color.WHITE);

	private AnimatableDouble coneAngle = new AnimatableDouble(90d, 0d, 180d);

	private AnimatableDouble coneFeather = new AnimatableDouble(50d, 0d, 100d);

	private boolean castsShadows = false;

	private AnimatableDouble shadowDarkness = new AnimatableDouble(100d, 0d, Double.POSITIVE_INFINITY);

	private AnimatableDouble shadowDiffusion = new AnimatableDouble(0d, 0d, Double.POSITIVE_INFINITY);


	public boolean isVideoEnabled() {
		return videoEnabled;
	}

	public void setVideoEnabled(boolean enabled) {
		videoEnabled = enabled;
	}

	public AnimatableVec3d getPointOfInterest() {
		return pointOfInterest;
	}

	public void setPointOfInterest(AnimatableVec3d pointOfInterest) {
		pointOfInterest.copyConfigurationFrom(this.pointOfInterest);
		this.pointOfInterest = pointOfInterest;
	}

	public AnimatableVec3d getPosition() {
		return position;
	}

	public void setPosition(AnimatableVec3d position) {
		position.copyConfigurationFrom(this.position);
		this.position = position;
	}

	public AnimatableVec3d getOrientation() {
		return orientation;
	}

	public void setOrientation(AnimatableVec3d orientation) {
		orientation.copyConfigurationFrom(this.orientation);
		this.orientation = orientation;
	}

	public AnimatableDouble getRotationX() {
		return rotationX;
	}

	public void setRotationX(AnimatableDouble rotationX) {
		rotationX.copyConfigurationFrom(this.rotationX);
		this.rotationX = rotationX;
	}

	public AnimatableDouble getRotationY() {
		return rotationY;
	}

	public void setRotationY(AnimatableDouble rotationY) {
		rotationY.copyConfigurationFrom(this.rotationY);
		this.rotationY = rotationY;
	}

	public AnimatableDouble getRotationZ() {
		return rotationZ;
	}

	public void setRotationZ(AnimatableDouble rotationZ) {
		rotationZ.copyConfigurationFrom(this.rotationZ);
		this.rotationZ = rotationZ;
	}

	public LightType getLightType() {
		return lightType;
	}

	public void setLightType(LightType lightType) {
		this.lightType = lightType;
	}

	public AnimatableDouble getIntensity() {
		return intensity;
	}

	public void setIntensity(AnimatableDouble intensity) {
		intensity.copyConfigurationFrom(this.intensity);
		this.intensity = intensity;
	}

	public AnimatableVec3d getAttenuation() {
		return attenuation;
	}

	public void setAttenuation(AnimatableVec3d attenuation) {
		attenuation.copyConfigurationFrom(this.attenuation);
		this.attenuation = attenuation;
	}

	public AnimatableColor getColor() {
		return color;
	}

	public void setColor(AnimatableColor color) {
		color.copyConfigurationFrom(this.color);
		this.color = color;
	}

	public AnimatableDouble getConeAngle() {
		return coneAngle;
	}

	public void setConeAngle(AnimatableDouble coneAngle) {
		coneAngle.copyConfigurationFrom(this.coneAngle);
		this.coneAngle = coneAngle;
	}

	public AnimatableDouble getConeFeather() {
		return coneFeather;
	}

	public void setConeFeather(AnimatableDouble coneFeather) {
		coneFeather.copyConfigurationFrom(this.coneFeather);
		this.coneFeather = coneFeather;
	}

	public boolean isCastsShadows() {
		return castsShadows;
	}

	public void setCastsShadows(boolean castsShadows) {
		this.castsShadows = castsShadows;
	}

	public AnimatableDouble getShadowDarkness() {
		return shadowDarkness;
	}

	public void setShadowDarkness(AnimatableDouble shadowDarkness) {
		shadowDarkness.copyConfigurationFrom(this.shadowDarkness);
		this.shadowDarkness = shadowDarkness;
	}

	public AnimatableDouble getShadowDiffusion() {
		return shadowDiffusion;
	}

	public void setShadowDiffusion(AnimatableDouble shadowDiffusion) {
		shadowDiffusion.copyConfigurationFrom(this.shadowDiffusion);
		this.shadowDiffusion = shadowDiffusion;
	}

	@Override
	public void prepareExpression(ExpressionScope scope) {
		super.prepareExpression(scope);

		scope.assignTo(orientation);
		scope.assignTo(rotationX);
		scope.assignTo(rotationY);
		scope.assignTo(rotationZ);
		scope.assignTo(position);
		scope.assignTo(pointOfInterest);

		scope.assignTo(intensity);
		scope.assignTo(attenuation);
		scope.assignTo(color);
		scope.assignTo(coneAngle);
		scope.assignTo(coneFeather);
		scope.assignTo(shadowDarkness);
		scope.assignTo(shadowDiffusion);
	}

	public Object createExpressionElement(CoreContext context) {
		return new LightLayerExpressionElement(context);
	}

	public class LightLayerExpressionElement extends LayerExpressionElement {

		public LightLayerExpressionElement(CoreContext context) {
			super(context);
		}

		public Object getOrientation()		{ return elem(orientation); }
		public Object getRotation()			{ return getRotationZ(); }		// ←ライトにもこれ必要だろうか？
		public Object getRotationX()		{ return elem(rotationX); }
		public Object getRotationY()		{ return elem(rotationY); }
		public Object getRotationZ()		{ return elem(rotationZ); }
		public Object getPosition()			{ return elem(position); }
		public Object getPointOfInterest()	{ return elem(pointOfInterest); }
		public String getLightType()		{ return lightType.name(); }
		public Object getIntensity()		{ return elem(intensity); }
		public Object getAttenuation()		{ return elem(attenuation); }
		public Object getColor()			{ return elem(color); }
		public Object getConeAngle()		{ return elem(coneAngle); }
		public Object getConeFeather()		{ return elem(coneFeather); }
		public boolean isCastsShadows()		{ return castsShadows; }
		public Object getShadowDarkness()	{ return elem(shadowDarkness); }
		public Object getShadowDiffusion()	{ return elem(shadowDiffusion); }
	}

}
