/*
 * Copyright (c) 2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.internal.services;

import java.util.HashMap;
import java.util.Map;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.core.services.QCIntegrationSupport;

public class QCIntegrationSupportImpl implements QCIntegrationSupport {

	private boolean syncWithCamera;

	private final Map<String, Object> inputMap = new HashMap<String, Object>();


	public void clear() {
		syncWithCamera = false;
		inputMap.clear();
	}

	public void setSyncWithCamera() {
		syncWithCamera = true;
	}

	public boolean isSyncWithCamera() {
		return syncWithCamera;
	}

	public void setValueForInputKey(String key, Boolean value) {
		inputMap.put(key, value);
	}

	public void setValueForInputKey(String key, Integer value) {
		inputMap.put(key, value);
	}

	public void setValueForInputKey(String key, Double value) {
		inputMap.put(key, value);
	}

	public void setValueForInputKey(String key, String value) {
		inputMap.put(key, value);
	}

	public void setValueForInputKey(String key, Color value) {
		inputMap.put(key, value);
	}

	public Object[] getInputKeyValues() {
		Object[] inputKeyValues = new Object[inputMap.size()*2];
		int i = 0;
		for (Map.Entry<String, Object> e : inputMap.entrySet()) {
			inputKeyValues[i++] = e.getKey();
			inputKeyValues[i++] = e.getValue();
		}
		return inputKeyValues;
	}

}
