/*
 * Copyright (c) 2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.effects.time;

import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.Effect.Categories;
import ch.kuramo.javie.api.services.IAudioEffectContext;
import ch.kuramo.javie.api.services.IEffectContext;
import ch.kuramo.javie.api.services.IVideoEffectContext;

import com.google.inject.Inject;

@Effect(id="ch.kuramo.javie.TimeShift", category=Categories.TIME)
public class TimeShift {

	public enum Track { BOTH, VIDEO, AUDIO }

	@Property
	private IAnimatableDouble timeShift;

	@Property("VIDEO_AND_AUDIO")
	private IAnimatableEnum<Track> track;


	private final IVideoEffectContext videoContext;

	private final IAudioEffectContext audioContext;

	@Inject
	public TimeShift(IVideoEffectContext videoContext, IAudioEffectContext audioContext) {
		this.videoContext = videoContext;
		this.audioContext = audioContext;
	}

	private void shiftTime(IEffectContext context) {
		Time time = context.getTime();
		double timeShift = context.value(this.timeShift);

		long timeValue = (long)(time.timeValue + timeShift*time.timeScale);

		context.setTime(new Time(timeValue, time.timeScale));
	}

	public IVideoBuffer doVideoEffect() {
		if (videoContext.value(track) != Track.AUDIO) {
			shiftTime(videoContext);
		}
		return videoContext.doPreviousEffect();
	}

	public IAudioBuffer doAudioEffect() {
		if (audioContext.value(track) != Track.VIDEO) {
			shiftTime(audioContext);
		}
		return audioContext.doPreviousEffect();
	}

}
