/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl.egl;

import com.jogamp.opengl.impl.GLDrawableImpl;
import com.jogamp.opengl.impl.GLDynamicLookupHelper;
import com.jogamp.opengl.impl.egl.EGL;
import com.jogamp.opengl.impl.egl.EGLDrawableFactory;
import com.jogamp.opengl.impl.egl.EGLGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.egl.EGLGraphicsDevice;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public abstract class EGLDrawable
extends GLDrawableImpl {
    protected boolean ownEGLDisplay = false;
    protected boolean ownEGLSurface = false;
    private EGLGraphicsConfiguration eglConfig;
    protected long eglDisplay = 0L;
    protected long eglSurface = 0L;

    protected EGLDrawable(EGLDrawableFactory eGLDrawableFactory, NativeSurface nativeSurface) throws GLException {
        super(eGLDrawableFactory, nativeSurface, false);
    }

    public long getDisplay() {
        return this.eglDisplay;
    }

    public long getHandle() {
        return this.eglSurface;
    }

    public EGLGraphicsConfiguration getGraphicsConfiguration() {
        return this.eglConfig;
    }

    public GLCapabilitiesImmutable getChosenGLCapabilities() {
        return null == this.eglConfig ? super.getChosenGLCapabilities() : (GLCapabilitiesImmutable)this.eglConfig.getChosenCapabilities();
    }

    public abstract GLContext createContext(GLContext var1);

    protected abstract long createSurface(long var1, long var3, long var5);

    private void recreateSurface() {
        if (0L != this.eglSurface) {
            EGL.eglDestroySurface(this.eglDisplay, this.eglSurface);
        }
        if (DEBUG) {
            System.err.println("createSurface using eglDisplay 0x" + Long.toHexString(this.eglDisplay) + ", " + this.eglConfig);
        }
        this.eglSurface = this.createSurface(this.eglDisplay, this.eglConfig.getNativeConfig(), this.surface.getSurfaceHandle());
        if (0L == this.eglSurface) {
            throw new GLException("Creation of window surface failed: " + this.eglConfig + ", error 0x" + Integer.toHexString(EGL.eglGetError()));
        }
        if (DEBUG) {
            System.err.println("setSurface using component: handle 0x" + Long.toHexString(this.surface.getSurfaceHandle()) + " -> 0x" + Long.toHexString(this.eglSurface));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setRealizedImpl() {
        if (this.realized) {
            AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.surface.getGraphicsConfiguration().getNativeGraphicsConfiguration();
            AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
            if (abstractGraphicsDevice instanceof EGLGraphicsDevice) {
                if (DEBUG) {
                    System.err.println("EGLDrawable.setRealized: using existing EGL config: " + this);
                }
                this.eglDisplay = abstractGraphicsDevice.getHandle();
                if (this.eglDisplay == 0L) {
                    throw new GLException("Invalid EGL display in EGLGraphicsDevice from " + abstractGraphicsDevice);
                }
                if (!(abstractGraphicsConfiguration instanceof EGLGraphicsConfiguration)) throw new GLException("EGLGraphicsDevice hold by non EGLGraphicsConfiguration: " + abstractGraphicsConfiguration);
                this.eglConfig = (EGLGraphicsConfiguration)abstractGraphicsConfiguration;
                if (null == this.eglConfig) {
                    throw new GLException("Null EGLGraphicsConfiguration from " + abstractGraphicsConfiguration);
                }
                int[] nArray = new int[1];
                if (0L != this.surface.getSurfaceHandle() && EGL.eglQuerySurface(this.eglDisplay, this.surface.getSurfaceHandle(), 12328, nArray, 0)) {
                    this.eglSurface = this.surface.getSurfaceHandle();
                    if (!DEBUG) return;
                    System.err.println("setSurface re-using component's EGLSurface: handle 0x" + Long.toHexString(this.eglSurface));
                    return;
                } else {
                    this.ownEGLSurface = true;
                    this.eglConfig.updateGraphicsConfiguration();
                    this.recreateSurface();
                }
                return;
            } else {
                if (DEBUG) {
                    System.err.println("EGLDrawable.setRealized: creating new EGL config: " + this);
                }
                this.ownEGLDisplay = true;
                this.ownEGLSurface = true;
                long l = 0L;
                l = "Windows".equals(NativeWindowFactory.getNativeWindowType((boolean)false)) ? this.surface.getSurfaceHandle() : abstractGraphicsDevice.getHandle();
                this.eglDisplay = EGL.eglGetDisplay(l);
                if (this.eglDisplay == 0L) {
                    if (DEBUG) {
                        System.err.println("eglDisplay(" + Long.toHexString(l) + " <surfaceHandle>): failed, using EGL_DEFAULT_DISPLAY");
                    }
                    l = 0L;
                    this.eglDisplay = EGL.eglGetDisplay(l);
                }
                if (this.eglDisplay == 0L) {
                    throw new GLException("Failed to created EGL display: nhandle 0x" + Long.toHexString(l) + ", " + abstractGraphicsDevice + ", error 0x" + Integer.toHexString(EGL.eglGetError()));
                }
                if (DEBUG) {
                    System.err.println("eglDisplay(" + Long.toHexString(l) + "): 0x" + Long.toHexString(this.eglDisplay));
                }
                if (!EGL.eglInitialize(this.eglDisplay, null, null)) {
                    throw new GLException("eglInitialize failed, error 0x" + Integer.toHexString(EGL.eglGetError()));
                }
                EGLGraphicsDevice eGLGraphicsDevice = new EGLGraphicsDevice(this.eglDisplay, "decon", 0);
                DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen((AbstractGraphicsDevice)eGLGraphicsDevice, abstractGraphicsConfiguration.getScreen().getIndex());
                GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getChosenCapabilities();
                GLCapabilitiesImmutable gLCapabilitiesImmutable2 = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getRequestedCapabilities();
                this.eglConfig = (EGLGraphicsConfiguration)GraphicsConfigurationFactory.getFactory((AbstractGraphicsDevice)eGLGraphicsDevice).chooseGraphicsConfiguration((CapabilitiesImmutable)gLCapabilitiesImmutable, (CapabilitiesImmutable)gLCapabilitiesImmutable2, null, (AbstractGraphicsScreen)defaultGraphicsScreen);
                if (null == this.eglConfig) {
                    throw new GLException("Couldn't create EGLGraphicsConfiguration from " + defaultGraphicsScreen);
                }
                if (DEBUG) {
                    System.err.println("Chosen eglConfig: " + this.eglConfig);
                }
                this.recreateSurface();
            }
            return;
        } else {
            if (!this.ownEGLSurface || this.eglSurface == 0L) return;
            if (!EGL.eglDestroySurface(this.eglDisplay, this.eglSurface)) {
                throw new GLException("Error destroying window surface (eglDestroySurface)");
            }
            this.eglSurface = 0L;
            if (this.ownEGLDisplay && 0L != this.eglDisplay) {
                EGL.eglTerminate(this.eglDisplay);
            }
            this.eglDisplay = 0L;
            this.eglConfig = null;
        }
    }

    public int getWidth() {
        int[] nArray = new int[1];
        if (!EGL.eglQuerySurface(this.eglDisplay, this.eglSurface, 12375, nArray, 0)) {
            throw new GLException("Error querying surface width");
        }
        return nArray[0];
    }

    public int getHeight() {
        int[] nArray = new int[1];
        if (!EGL.eglQuerySurface(this.eglDisplay, this.eglSurface, 12374, nArray, 0)) {
            throw new GLException("Error querying surface height");
        }
        return nArray[0];
    }

    public GLDynamicLookupHelper getGLDynamicLookupHelper() {
        if (this.getGLProfile().usesNativeGLES2()) {
            return this.getFactoryImpl().getGLDynamicLookupHelper(2);
        }
        if (this.getGLProfile().usesNativeGLES1()) {
            return this.getFactoryImpl().getGLDynamicLookupHelper(1);
        }
        throw new GLException("Unsupported: " + this.getGLProfile());
    }

    public String toString() {
        return this.getClass().getName() + "[realized " + this.isRealized() + ",\n\tfactory    " + this.getFactory() + ",\n\tsurface    " + this.getNativeSurface() + ",\n\teglSurface  0x" + Long.toHexString(this.eglSurface) + ",\n\teglConfig  " + this.eglConfig + ",\n\trequested  " + this.getRequestedGLCapabilities() + ",\n\tchosen     " + this.getChosenGLCapabilities() + "]";
    }
}

