/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.api.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * この注釈は {@link ch.kuramo.javie.api.IAnimatableValue}
 * のサブインターフェースと共に使用し、アニメーション可能なプロパティを宣言します。
 * 使用例は {@link ch.kuramo.javie.api.IAnimatableDouble} をご覧ください。
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface Property {

	/**
	 * <p>プロパティの初期値です。初期値は文字列で指定します。</p>
	 * <p>{@link ch.kuramo.javie.api.IAnimatableBoolean} の場合、"true" または "false" です。</p>
	 * <p>{@link ch.kuramo.javie.api.IAnimatableColor}
	 * の場合、色のRGB成分およびアルファ値をカンマ区切りで連結した文字列です。(例："1, 0.5, 0, 1")</p>
	 * <p>{@link ch.kuramo.javie.api.IAnimatableDouble} および
	 * {@link ch.kuramo.javie.api.IAnimatableInteger} の場合、数値をそのまま文字列として指定します。</p>
	 * <p>{@link ch.kuramo.javie.api.IAnimatableEnum} の場合、enum 定数の名前を文字列として指定します。</p>
	 * <p>{@link ch.kuramo.javie.api.IAnimatableLayerReference} は初期値を指定することはできません。
	 * <p>{@link ch.kuramo.javie.api.IAnimatableString} の場合、文字列をそのまま指定します。</p>
	 * <p>{@link ch.kuramo.javie.api.IAnimatableVec2d} および
	 * {@link ch.kuramo.javie.api.IAnimatableVec3d}
	 * の場合、x, y または x, y, z の値をカンマ区切りで連結した文字列です。(例："100, 100, 100")</p>
	 * 
	 * @return プロパティの初期値
	 */
	String value() default "";

	/**
	 * プロパティの最小値です。最小値を指定できるのは、
	 * {@link ch.kuramo.javie.api.IAnimatableDouble} ,
	 * {@link ch.kuramo.javie.api.IAnimatableInteger} ,
	 * {@link ch.kuramo.javie.api.IAnimatableVec2d} ,
	 * {@link ch.kuramo.javie.api.IAnimatableVec3d}
	 * のみです。{@link #value()} と同じ形式で指定します。
	 * 
	 * @return プロパティの最小値
	 */
	String min() default "";

	/**
	 * プロパティの最大値です。最大値を指定できるのは、
	 * {@link ch.kuramo.javie.api.IAnimatableDouble} ,
	 * {@link ch.kuramo.javie.api.IAnimatableInteger} ,
	 * {@link ch.kuramo.javie.api.IAnimatableVec2d} ,
	 * {@link ch.kuramo.javie.api.IAnimatableVec3d}
	 * のみです。{@link #value()} と同じ形式で指定します。
	 * 
	 * @return プロパティの最大値
	 */
	String max() default "";

}
