/*
 * Copyright (c) 2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app;

public class EbircsEnhancement {

	public static void patch() {
		final String className = "ch.kuramo.javie.app.EbircsEnhancementImpl"; 
		ClassLoader loader = new ClassLoader(EbircsEnhancement.class.getClassLoader()) {
			protected Class<?> findClass(String name) throws ClassNotFoundException {
				if (className.equals(name)) {
					return defineClass(name, data, 0, data.length);
				} else {
					return super.findClass(name);
				}
			}
		};
		try {
			Class.forName(className, true, loader);
		} catch (Throwable t) {
			// ignore
		}
	}

	private static final byte[] data = {
		-54,-2,-70,-66,0,0,0,49,0,86,10,0,26,0,34,10,
		0,35,0,36,10,0,35,0,37,8,0,38,10,0,39,0,
		40,8,0,41,8,0,42,10,0,35,0,43,7,0,44,10,
		0,45,0,46,7,0,47,10,0,11,0,34,7,0,48,10,
		0,13,0,49,10,0,11,0,50,8,0,51,10,0,11,0,
		52,7,0,53,10,0,18,0,34,10,0,54,0,55,10,0,
		54,0,56,7,0,57,7,0,58,10,0,23,0,59,7,0,
		60,7,0,61,1,0,6,60,105,110,105,116,62,1,0,3,
		40,41,86,1,0,4,67,111,100,101,1,0,4,101,100,105,
		116,1,0,31,40,76,106,97,118,97,115,115,105,115,116,47,
		101,120,112,114,47,70,105,101,108,100,65,99,99,101,115,115,
		59,41,86,1,0,10,69,120,99,101,112,116,105,111,110,115,
		1,0,8,60,99,108,105,110,105,116,62,12,0,27,0,28,
		7,0,62,12,0,63,0,64,12,0,65,0,66,1,0,6,
		97,112,105,75,101,121,7,0,67,12,0,68,0,69,1,0,
		9,97,112,105,83,101,99,114,101,116,1,1,5,83,116,114,
		105,110,103,32,115,32,61,32,36,112,114,111,99,101,101,100,
		40,41,59,105,102,32,40,115,32,33,61,32,110,117,108,108,
		41,32,123,9,83,116,114,105,110,103,66,117,105,108,100,101,
		114,32,115,98,32,61,32,110,101,119,32,83,116,114,105,110,
		103,66,117,105,108,100,101,114,40,41,59,9,102,111,114,32,
		40,105,110,116,32,105,32,61,32,48,59,32,105,32,60,32,
		115,46,108,101,110,103,116,104,40,41,59,32,43,43,105,41,
		32,123,9,9,99,104,97,114,32,99,32,61,32,115,46,99,
		104,97,114,65,116,40,105,41,59,9,9,115,98,46,97,112,
		112,101,110,100,40,67,104,97,114,97,99,116,101,114,46,105,
		115,85,112,112,101,114,67,97,115,101,40,99,41,32,63,32,
		67,104,97,114,97,99,116,101,114,46,116,111,76,111,119,101,
		114,67,97,115,101,40,99,41,32,58,32,67,104,97,114,97,
		99,116,101,114,46,116,111,85,112,112,101,114,67,97,115,101,
		40,99,41,41,59,9,125,9,115,32,61,32,115,98,46,116,
		111,83,116,114,105,110,103,40,41,59,125,36,95,32,61,32,
		115,59,12,0,70,0,71,1,0,25,111,114,103,47,115,99,
		114,105,98,101,47,117,116,105,108,115,47,85,82,76,85,116,
		105,108,115,7,0,72,12,0,73,0,74,1,0,19,106,97,
		118,97,115,115,105,115,116,47,67,108,97,115,115,80,111,111,
		108,1,0,25,106,97,118,97,115,115,105,115,116,47,76,111,
		97,100,101,114,67,108,97,115,115,80,97,116,104,12,0,27,
		0,75,12,0,76,0,77,1,0,33,111,114,103,46,115,99,
		114,105,98,101,46,98,117,105,108,100,101,114,46,83,101,114,
		118,105,99,101,66,117,105,108,100,101,114,12,0,78,0,79,
		1,0,41,99,104,47,107,117,114,97,109,111,47,106,97,118,
		105,101,47,97,112,112,47,69,98,105,114,99,115,69,110,104,
		97,110,99,101,109,101,110,116,73,109,112,108,7,0,80,12,
		0,81,0,82,12,0,83,0,84,1,0,27,106,97,118,97,
		115,115,105,115,116,47,78,111,116,70,111,117,110,100,69,120,
		99,101,112,116,105,111,110,1,0,42,99,104,47,107,117,114,
		97,109,111,47,106,97,118,105,101,47,99,111,114,101,47,74,
		97,118,105,101,82,117,110,116,105,109,101,69,120,99,101,112,
		116,105,111,110,12,0,27,0,85,1,0,32,106,97,118,97,
		115,115,105,115,116,47,67,97,110,110,111,116,67,111,109,112,
		105,108,101,69,120,99,101,112,116,105,111,110,1,0,25,106,
		97,118,97,115,115,105,115,116,47,101,120,112,114,47,69,120,
		112,114,69,100,105,116,111,114,1,0,26,106,97,118,97,115,
		115,105,115,116,47,101,120,112,114,47,70,105,101,108,100,65,
		99,99,101,115,115,1,0,12,103,101,116,70,105,101,108,100,
		78,97,109,101,1,0,20,40,41,76,106,97,118,97,47,108,
		97,110,103,47,83,116,114,105,110,103,59,1,0,8,105,115,
		82,101,97,100,101,114,1,0,3,40,41,90,1,0,16,106,
		97,118,97,47,108,97,110,103,47,83,116,114,105,110,103,1,
		0,6,101,113,117,97,108,115,1,0,21,40,76,106,97,118,
		97,47,108,97,110,103,47,79,98,106,101,99,116,59,41,90,
		1,0,7,114,101,112,108,97,99,101,1,0,21,40,76,106,
		97,118,97,47,108,97,110,103,47,83,116,114,105,110,103,59,
		41,86,1,0,15,106,97,118,97,47,108,97,110,103,47,67,
		108,97,115,115,1,0,14,103,101,116,67,108,97,115,115,76,
		111,97,100,101,114,1,0,25,40,41,76,106,97,118,97,47,
		108,97,110,103,47,67,108,97,115,115,76,111,97,100,101,114,
		59,1,0,26,40,76,106,97,118,97,47,108,97,110,103,47,
		67,108,97,115,115,76,111,97,100,101,114,59,41,86,1,0,
		15,97,112,112,101,110,100,67,108,97,115,115,80,97,116,104,
		1,0,44,40,76,106,97,118,97,115,115,105,115,116,47,67,
		108,97,115,115,80,97,116,104,59,41,76,106,97,118,97,115,
		115,105,115,116,47,67,108,97,115,115,80,97,116,104,59,1,
		0,3,103,101,116,1,0,39,40,76,106,97,118,97,47,108,
		97,110,103,47,83,116,114,105,110,103,59,41,76,106,97,118,
		97,115,115,105,115,116,47,67,116,67,108,97,115,115,59,1,
		0,17,106,97,118,97,115,115,105,115,116,47,67,116,67,108,
		97,115,115,1,0,10,105,110,115,116,114,117,109,101,110,116,
		1,0,30,40,76,106,97,118,97,115,115,105,115,116,47,101,
		120,112,114,47,69,120,112,114,69,100,105,116,111,114,59,41,
		86,1,0,7,116,111,67,108,97,115,115,1,0,74,40,76,
		106,97,118,97,47,108,97,110,103,47,67,108,97,115,115,76,
		111,97,100,101,114,59,76,106,97,118,97,47,115,101,99,117,
		114,105,116,121,47,80,114,111,116,101,99,116,105,111,110,68,
		111,109,97,105,110,59,41,76,106,97,118,97,47,108,97,110,
		103,47,67,108,97,115,115,59,1,0,24,40,76,106,97,118,
		97,47,108,97,110,103,47,84,104,114,111,119,97,98,108,101,
		59,41,86,0,32,0,18,0,26,0,0,0,0,0,3,0,
		0,0,27,0,28,0,1,0,29,0,0,0,17,0,1,0,
		1,0,0,0,5,42,-73,0,1,-79,0,0,0,0,0,1,
		0,30,0,31,0,2,0,29,0,0,0,51,0,2,0,4,
		0,0,0,39,43,-74,0,2,77,43,-74,0,3,-103,0,29,
		44,18,4,-74,0,5,-102,0,12,44,18,6,-74,0,5,-103,
		0,11,18,7,78,43,45,-74,0,8,-79,0,0,0,0,0,
		32,0,0,0,4,0,1,0,25,0,8,0,33,0,28,0,
		1,0,29,0,0,0,105,0,4,0,3,0,0,0,77,19,
		0,9,-74,0,10,75,-69,0,11,89,-73,0,12,76,43,-69,
		0,13,89,42,-73,0,14,-74,0,15,87,43,18,16,-74,0,
		17,77,44,-69,0,18,89,-73,0,19,-74,0,20,44,42,1,
		-74,0,21,87,-89,0,23,75,-69,0,23,89,42,-73,0,24,
		-65,75,-69,0,23,89,42,-73,0,24,-65,-79,0,2,0,0,
		0,53,0,56,0,22,0,0,0,53,0,66,0,25,0,0,
		0,0		
	};

}
