/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.wizards;

import org.eclipse.jface.wizard.Wizard;

import ch.kuramo.javie.app.project.NewSolidColorItemOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.core.Folder;

public class SolidColorItemWizard extends Wizard {

	private static SolidColorItemSettings _defaultSettings = new SolidColorItemSettings();


	private final ProjectManager _projectManager;

	private final Folder _parent;

	private SolidColorItemWizardPage _page;


	public SolidColorItemWizard(ProjectManager projectManager, Folder parent) {
		super();
		_projectManager = projectManager;
		_parent = parent;
		setWindowTitle("新規平面");
	}

	public void addPages() {
		SolidColorItemSettings settings = _defaultSettings.clone();
		settings.name = _projectManager.getUnusedItemName("平面");

		_page = new SolidColorItemWizardPage(settings);
		addPage(_page);
	}

	public boolean performFinish() {
		SolidColorItemSettings settings = _page.getResult();
		if (settings == null) {
			return false;
		}

		NewSolidColorItemOperation operation = new NewSolidColorItemOperation(
				_projectManager, _parent, settings.name, settings.width, settings.height, settings.color);

		_projectManager.postOperation(operation);

		_defaultSettings = settings;
		return true;
	}

}
