/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core;

import net.arnx.jsonic.JSONHint;

public abstract class AbstractItem implements Item {

	private String _id;

	private String _parentId;

	private Folder _parent;

	private String _name;

	private Label _label;


	public AbstractItem() {
		super();
	}

	protected void initialize() {
		_id = Util.randomId();
	}

	public String getId() {
		return _id;
	}

	public void setId(String id) {
		_id = id;
	}

	public String getParentId() {
		return _parentId;
	}

	public void setParentId(String parentId) {
		_parentId = parentId;
	}

	@JSONHint(ignore=true)
	public Folder getParent() {
		return _parent;
	}

	@JSONHint(ignore=true)
	public void setParent(Folder parent) {
		_parentId = (parent != null) ? parent.getId() : null;
		_parent = parent;
	}

	public String getName() {
		return _name;
	}

	public void setName(String name) {
		_name = name;
	}

	public Label getLabel() {
		return _label;
	}

	public void setLabel(Label label) {
		_label = label;
	}

	public void afterDecode(Project p) throws ProjectDecodeException {
		if (_parentId != null) {
			_parent = p.getItem(_parentId);
			if (_parent == null) {
				throw new ProjectDecodeException(
						"no such parent folder found: id=" + _parentId);
			}
		}
	}

}
