/*
 * Copyright (c) 2010,2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.misc;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import ch.kuramo.javie.core.JavieRuntimeException;

import com.jogamp.opengl.impl.awt.Java2DGLContext;

public class Java2DFboBugFix {

	public static void patch() {
		if (System.getProperty("os.name").toLowerCase().contains("windows")
				&& !Boolean.getBoolean("sun.java2d.opengl.fbobject")) {
			noFBOSupportFix();
		}
	}

	private static void noFBOSupportFix() {
		try {
			ClassLoader loader = Java2DGLContext.class.getClassLoader();

			ClassPool pool = new ClassPool();
			pool.appendClassPath(new LoaderClassPath(loader));
			CtClass targetClass = pool.get("com.jogamp.opengl.impl.awt.Java2D");

			targetClass.instrument(new ExprEditor() {
				public void edit(FieldAccess f) throws CannotCompileException {
					if (f.getFieldName().equals("fbObjectSupportInitialized") && f.isReader()) {
						f.replace("$_ = false;");
					}
				}
			});

			targetClass.toClass(loader, null);

		} catch (NotFoundException e) {
			throw new JavieRuntimeException(e);
		} catch (CannotCompileException e) {
			throw new JavieRuntimeException(e);
		}
	}


	private Java2DFboBugFix() { }

}
