/*
 * Copyright (c) 2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#pragma once

class VideoSource
{
public:
	static int InitDXVA2(HWND hwnd);

	VideoSource(BOOL sysMem);
	~VideoSource();

	HRESULT InitWithFile(LPCWSTR file);
	HRESULT FrameSurfaceAtTime(LONGLONG* ioTime, LONGLONG limitTime, IDirect3DSurface9** outSurface);

	HRESULT LockSurface(IDirect3DSurface9* surface, D3DLOCKED_RECT* outLockedRect);
	HRESULT UnlockSurface(IDirect3DSurface9* surface);
	HRESULT ReleaseSurface(IDirect3DSurface9* surface);

	UINT32 GetWidth() const					{ return mWidth; }
	UINT32 GetHeight() const				{ return mHeight; }
	BOOL IsTopDown() const					{ return mTopDown; }
	LONGLONG GetDuration() const			{ return mDuration; }
	const MFRatio& GetFrameRate() const		{ return mFrameRate; }

private:
	HRESULT LockDevice(IDirect3DDevice9** outDevice);
	HRESULT UnlockDevice(IDirect3DDevice9* device);

	static IDirect3DDeviceManager9* sD3DManager;
	static UINT sResetToken;

	UINT32 mWidth;
	UINT32 mHeight;
	BOOL mTopDown;
	MFRatio mPixAspectRatio;
	LONGLONG mDuration;
	MFRatio mFrameRate;

	IMFSourceReader* mReader;
	HANDLE mDevHandle;

	BOOL mSysMem;
};

class AudioSource {
public:
	AudioSource();
	~AudioSource();

	HRESULT InitWithFile(LPCWSTR file);
	HRESULT ReadBufferAtTime(LONGLONG* ioTime, IMFMediaBuffer** outMedbuf, DWORD* outLen);

	LONGLONG GetDuration() const		{ return mDuration; }
	UINT32 GetSampleRate() const		{ return mSampleRate; }
	UINT32 GetSampleSizeInBits() const	{ return mSampleSizeInBits; }
	UINT32 GetChannels() const			{ return mChannels; }
	BOOL IsFloat() const				{ return mFloat; }

private:
	LONGLONG mDuration;
	UINT32 mSampleRate;
	UINT32 mSampleSizeInBits;
	UINT32 mChannels;
	BOOL mFloat;

	IMFSourceReader* mReader;
};
