/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.util.Enumeration;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.NullFormatter;
import net.arnx.jsonic.io.OutputSource;

final class EnumerationFormatter
implements Formatter {
    public static final EnumerationFormatter INSTANCE = new EnumerationFormatter();

    EnumerationFormatter() {
    }

    public boolean accept(Object o) {
        return o instanceof Enumeration;
    }

    public boolean isStruct() {
        return true;
    }

    public void format(JSON.Context context, Object src, Object o, OutputSource out) throws Exception {
        Enumeration e = (Enumeration)o;
        JSONHint hint = context.getHint();
        out.append('[');
        int count = 0;
        Class<?> lastClass = null;
        Formatter lastFormatter = null;
        while (e.hasMoreElements()) {
            Object item = e.nextElement();
            if (item == src) {
                item = null;
            }
            if (count != 0) {
                out.append(',');
            }
            if (context.isPrettyPrint()) {
                out.append('\n');
                context.appendIndent(out, context.getDepth() + 1);
            }
            context.enter(count, hint);
            item = context.preformatInternal(item);
            if (item == null) {
                NullFormatter.INSTANCE.format(context, src, item, out);
            } else if (hint == null) {
                if (item.getClass() == lastClass) {
                    lastFormatter.format(context, src, item, out);
                } else {
                    lastFormatter = context.formatInternal(item, out);
                    lastClass = item.getClass();
                }
            } else {
                context.formatInternal(item, out);
            }
            context.exit();
            ++count;
        }
        if (context.isPrettyPrint() && count > 0) {
            out.append('\n');
            context.appendIndent(out, context.getDepth());
        }
        out.append(']');
    }
}

