##############################################################################
#
# JCodeChanger.py
#
# Copyright (C) 2003, Shu KONNO (owa@bg.wakwak.com) All Rights Reserved.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided that
# the above copyright notice appear in all copies and that both that copyright
# notice and this permission notice appear in supporting documentation, and that
# the name of Atsuo Ishimoto not be used in advertising or publicity pertaining
# to distribution of the software without specific, written prior permission.
#
# SHU KONNO DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
# INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
# EVENT SHALL SHIBAT ATSUSHI BE LIABLE FOR ANY SPECIAL, INDIRECT OR
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
# USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
# OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
# PERFORMANCE OF THIS SOFTWARE.
#
##############################################################################
""" JCodeChanger Zope Product.
 JCodeChanger can change the jpanese encodings of zope objects.
 - Can change object's property 'management_page_charset'.
 - Can change object's text encoding.
"""
from OFS.SimpleItem import Item
from Globals import Persistent, DTMLFile
from Acquisition import Implicit
from Products.ZCatalog import ZCatalog
from App.Common import package_home
import os, string
import csutil, miscobj

dtml_add = DTMLFile('dtml/ManageAdd', globals())

def manage_add(self, id, REQUEST, title=''):
	""" Method for adding a JCodeChanger object """
	if REQUEST is not None:
		if REQUEST.get('push', 'Cancel') == 'OK':
			newEncoder = JCodeChanger(id, title)
			self._setObject(id, newEncoder)
		return self.manage_main(self, REQUEST)

class JCodeChanger(Item, Persistent, Implicit):
	""" JCodeChanger Class """
	meta_type = "JCodeChanger"

	manage_options = (
		{'label':'Edit', 'action':'manage_edit'},
		{'label':'Setup', 'action':'manage_setup'},
		{'label':'Readme', 'action':'dtml_readme'},
		)

	# Web Method
	dtml_setup = DTMLFile('dtml/ManageSetup', globals())
	dtml_edit = DTMLFile('dtml/ManageEdit', globals())
	dtml_readme = DTMLFile('dtml/README', globals())

	def __init__(self, id, title=''):
		""" method to initialize JCodeChanger instances """
		self.id = id;
		self.title = title
		self.cvlist = csutil.get_converter_list()
		self.cvnumb = 0
		self.cslist = ['none'] + csutil.get_encoding_list()
		self.csnumb = 0
		self.columns = 80

	def manage_setup(self, REQUEST=None):
		""" method to setup JCodeChanger instances """
		if REQUEST is not None:
			if REQUEST.form.has_key('title'):
				self.title = REQUEST.form['title']
			if REQUEST.form.has_key('cvnumb'):
				self.cvnumb = REQUEST.form['cvnumb']
			if REQUEST.form.has_key('columns'):
				self.columns = int(REQUEST.form['columns'])
			return self.dtml_setup(self, REQUEST)

	def manage_edit(self, pid='', eid='', pids=[], eids=[], REQUEST=None):
		""" method to edit JCodeChanger instances """
		if REQUEST is not None:
			if REQUEST.form.has_key('csnumb'):
				self.csnumb = REQUEST.form['csnumb']
				charset = self.cslist[self.csnumb]
				if charset != 'none':
					REQUEST['management_page_charset'] = charset
				if pid:
					self._change_property_cs(charset)
				if eid:
					self._change_encoding_cs(charset)
				if pids:
					self._change_items_property_cs(pids, charset)
				if eids:
					self._change_items_encoding_cs(eids, charset)
			return self.dtml_edit(self, REQUEST)

	def _change_property_cs(self, charset=''):
		"""  """
		try:
			folder = self.restrictedTraverse("../", None)
			pstr = 'management_page_charset'
			if charset == '' or charset == 'none':
				if folder.hasProperty(pstr):
					folder.manage_delProperties((pstr,))
			elif folder.hasProperty(pstr):
				folder.manage_changeProperties(management_page_charset=charset)
			else:
				folder.manage_addProperty(pstr, charset, 'string')
		except:
			pass

	def _change_encoding_cs(self, charset=''):
		""" """
		try:
			if charset and charset != 'none':
				ob = self.restrictedTraverse("../", None)
				cv = self.cvlist[self.cvnumb]
				if ob.title:
					ob.title = cv['func'](ob.title, charset)
		except:
			pass

	def _change_items_property_cs(self, pids=[], charset=''):
		""" """
		cv = self.cvlist[self.cvnumb]
		for name in pids:
			ob = self.restrictedTraverse('../' + name, None)
			pstr = 'management_page_charset'
			if charset == '' or charset == 'none':
				if ob.hasProperty(pstr):
					ob.manage_delProperties((pstr,))
			elif ob.hasProperty(pstr):
				ob.manage_changeProperties(management_page_charset=charset)
			else:
				ob.manage_addProperty(pstr, charset, 'string')

	def _change_items_encoding_cs(self, eids=[], charset=''):
		""" """
		if charset and charset != 'none':
			cv = self.cvlist[self.cvnumb]
			for name in eids:
				ob = self.restrictedTraverse('../' + name, None)
				miscobj.changeObjectCharset(ob, cv['func'], charset)

	def parent_charset(self):
		"""  """
		ob = self.REQUEST['PARENTS'][2]
		if ob.hasProperty('management_page_charset'):
			return ob.management_page_charset
		return ''

	def parent_editable(self):
		"""  """
		ob = self.REQUEST['PARENTS'][2]
		url = '/' + ob.absolute_url(1) + '/' + self.id + '/manage_edit'
		return self.restrictedTraverse(url, None)

	def parent_manage_url(self):
		"""  """
		ob = self.REQUEST['PARENTS'][2]
		return ob.absolute_url() + '/' + self.id + '/manage_edit'

	def parent_url(self):
		"""  """
		ob = self.REQUEST['PARENTS'][2]
		return '/' + ob.absolute_url(1)

	def get_object_items(self, ob):
		"""  """
		items = {
			'base_type':'',
			'property': '',
			'id':'',
			'title':'',
			'encoding':'',
			'text':'',
			}
		items['id'] = ob.getId()
		if ob.title:
			items['title'] = ob.title
		miscobj.getObjectItems(items, ob)
		if items['text'] > self.columns:
			items['text'] = items['text'][:self.columns]
		return items

	def get_message(self, s):
		return get_message(self, s)

def get_message(self, s):
	charset = self.REQUEST.get('management_page_charset', '')
	suffix = '.txt'
	if charset == 'euc-jp':
		suffix = '.euc'
	elif charset == 'utf-8':
		suffix = '.utf8'
	elif charset == 'shift_jis':
		suffix = '.sjis'
	path = os.path.join(package_home(globals()),"doc/" + s + suffix)
	try:
		f = open(path, 'r')
		s = f.read()
		f.close()
	except:
		s = ''
	return s

