##############################################################################
#
# csutil.py
#
# Copyright (C) 2003, Shu KONNO (owa@bg.wakwak.com) All Rights Reserved.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided that
# the above copyright notice appear in all copies and that both that copyright
# notice and this permission notice appear in supporting documentation, and that
# the name of Atsuo Ishimoto not be used in advertising or publicity pertaining
# to distribution of the software without specific, written prior permission.
#
# SHU KONNO DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
# INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
# EVENT SHALL SHIBAT ATSUSHI BE LIABLE FOR ANY SPECIAL, INDIRECT OR
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
# USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
# OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
# PERFORMANCE OF THIS SOFTWARE.
#
##############################################################################
cs_encoding_list = ['us_ascii', 'utf-8', 'euc-jp', 'shift_jis']
code_us			= cs_encoding_list[0]
code_utf8		= cs_encoding_list[1]
code_euc		= cs_encoding_list[2]
code_sjis		= cs_encoding_list[3]

cs_converter_list = []

def get_encoding_list():
	return cs_encoding_list

def get_converter_list():
	list = []
	for cv in cs_converter_list:
		items = {'func':cv, 'name':cv.__doc__[13:], 'exec':1}
		list.append(items)
	return list

def _is_all_ascii(s):
	for c in s:
		d = ord(c)
		if d > 0x7e:
			return 0
		if d < 0x20:
			if d != 0x0a and d != 0x0d and d != 0x09:
				return 0
	return 1

def guess(s):
	type = code_us
	if s and len(s) > 0 and not _is_all_ascii(s):
		try:
			import kconv
			c = kconv.ChkCoding(s)
			if c == kconv.UTF8:
				type = code_utf8
			elif c == kconv.EUC:
				type = code_euc
			elif c == kconv.SJIS:
				type = code_sjis
		except:
			pass
	return type

def guess2(s):
	type = code_us
	if s and len(s) > 0 and not _is_all_ascii(s):
		try:
			import pykf
			c = pykf.guess(s)
			if c == pykf.UTF8:
				type = code_utf8
			elif c == pykf.EUC:
				type = code_euc
			elif c == pykf.SJIS:
				type = code_sjis
		except:
			pass
	return type

def convert(s, dst_code, src_code='', list=[]):
	for cv in list:
		try:
			retstr = cv(s, dst_code, src_code)
			if retstr:
				return retstr
		except:
			pass
	return s

def _convert_by_kconv(s, dst_code, src_code=''):
	"""converter by kconv"""
	if dst_code == code_euc:
		return kconv.Kconv(kconv.EUC).convert(s)
	if dst_code == code_sjis:
		return kconv.Kconv(kconv.SJIS).convert(s)
	if dst_code == code_utf8:
		return kconv.Kconv(kconv.UTF8).convert(s)
	return None

def _convert_by_jplib(s, dst_code, src_code=''):
	"""converter by jplib"""
	if dst_code == code_euc:
		return jplib.euc(s)
	if dst_code == code_sjis:
		return jplib.sjis(s)
	if dst_code == code_utf8:
		return jplib.utf8(s)
	return None

def _convert_by_pykf(s, dst_code, src_code=''):
	"""converter by pykf"""
	try:
		if dst_code == code_euc:
			return pykf.toeuc(s)
		if dst_code == code_sjis:
			return pykf.tosjis(s)
		if dst_code == code_utf8:
			if not src_code:
				src_code = guess(s)
			if src_code == code_utf8:
				return s
			if src_code == code_euc:
				return unicode(s,'japanese.euc-jp','replace').encode('utf-8')
			if src_code == code_sjis:
				return unicode(s,'japanese.shift_jis','replace').encode('utf-8')
	except:
		pass
	return s

try:
		import kconv
		cs_converter_list.append(_convert_by_kconv)
except:
	pass

try:
		import jplib
		cs_converter_list.append(_convert_by_jplib)
except:
	pass

try:
		import pykf
		cs_converter_list.append(_convert_by_pykf)
except:
	pass

