##############################################################################
#
# miscobj.py
#
# Copyright (C) 2003, Shu KONNO (owa@bg.wakwak.com) All Rights Reserved.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided that
# the above copyright notice appear in all copies and that both that copyright
# notice and this permission notice appear in supporting documentation, and that
# the name of Atsuo Ishimoto not be used in advertising or publicity pertaining
# to distribution of the software without specific, written prior permission.
#
# SHU KONNO DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
# INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
# EVENT SHALL SHIBAT ATSUSHI BE LIABLE FOR ANY SPECIAL, INDIRECT OR
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
# USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
# OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
# PERFORMANCE OF THIS SOFTWARE.
#
##############################################################################
import csutil
from Products.ZCatalog import ZCatalog
from OFS.Folder import Folder

def _get_Document(ob):
	return ob.document_src();

def _get_Read(ob):
	return ob.read();

def _get_File(ob):
	if ob.getContentType()[:5] == 'text/':
		return ob.data;
	return None

def _get_TinyTablePlus(ob):
	return ob.data_text();

def _change_Document(ob, encoder, charset):
		""" see zope/lib/python/OFS/DTMLDocument.py """
		title = ''
		if ob.title:
			title = encoder(ob.title, charset)
		data = encoder(ob.document_src(), charset)
		ob.manage_edit(data, title)

def _change_PythonScript(ob, encoder, charset):
		""" see zope/lib/python/Products/PythonScripts/PythonScripts.py """
		params=ob.params()
		body = ob.document_src()
		body = encoder(body, charset)
		ob.ZPythonScript_edit(params, body)

def _change_File(ob, encoder, charset):
		""" see zope/lib/python/Products/OFSP/help/File.py """
		if ob.title:
			ob.title = encoder(ob.title, charset)
		if ob.getContentType()[:5] == 'text/':
			data = encoder(ob.data, charset)
			ob.update_data(data)

def _change_ZSQLMethod(ob, encoder, charset):
		""" see zope/lib/python/Products/ZSQLMethods/ """
		if ob.title:
			ob.title = encoder(ob.title, charset)
#		text = ob.document_src()
#		text = encoder(text, charset)

def _change_PageTemplate(ob, encoder, charset):
		""" see zope/lib/python/Products/PageTemplates/PageTemplates.py """
		if ob.title:
			ob.title = encoder(ob.title, charset)
		text = ob.read()
		text = encoder(text, charset)
		ob.write(text)

def _change_TinyTablePlus(ob, encoder, charset):
		data = encoder(ob.data_text(), charset)
		ob.manage_editData(data)
		if ob.title:
			ob.title = encoder(ob.title, charset)

_object_dict = {
	'DTML Method':
		(_get_Document, _change_Document),
	'DTML Document':
		(_get_Document, _change_Document),
	'ZWiki Page':
		(_get_Document, _change_Document),
	'Script (Python)':
		(_get_Document, _change_PythonScript),
	'Z SQL Method':
		(None, _change_ZSQLMethod),
	'Page Template':
		(_get_Read, _change_PageTemplate),
	'File':
		(_get_File, _change_File),
	'TinyTablePlus':
		(_get_TinyTablePlus, _change_TinyTablePlus),
	}

def changeObjectCharset(ob, encoder, charset):
	if isinstance(ob, Folder):
		ob.title = encoder(ob.title, charset)
	elif isinstance(ob, ZCatalog.ZCatalog):
		ob.title = encoder(ob.title, charset)
	else:
		pf = _object_dict.get(ob.meta_type, None);
		if pf and pf[1]:
			pf[1](ob, encoder, charset);
		elif ob.title:
			ob.title = encoder(ob.title, charset)

def getObjectItems(items, ob):
	""" items are meta_type, id, title, encoding, and text. """

	text = None
	if isinstance(ob, Folder):
		items['property'] = ob.getProperty('management_page_charset','')
		items['base_type'] = Folder.meta_type
	elif isinstance(ob, ZCatalog.ZCatalog):
		items['property'] = ob.getProperty('management_page_charset','')
		items['base_type'] = ZCatalog.ZCatalog.meta_type
	else:
		items['base_type'] = ob.meta_type
		pf = _object_dict.get(ob.meta_type, None);
		if pf:
			if pf[0]:
				text = pf[0](ob);
				items['text'] = text
		if text == None:
			items['text'] = '-'

	if ob.title:
		title = csutil.guess(ob.title)
		text = csutil.guess(text)
		if title == 'us_ascii' or title == text:
			items['encoding'] = text
		else:
			items['encoding'] = title
			if text != 'us_ascii':
				items['encoding'] += '/' + text
	elif text:
		items['encoding'] = csutil.guess(text)
	else:
		del items['encoding']

