/*
 * Decompiled with CFR 0.152.
 */
package ams.com.ams.jdbcdebug.util;

import ams.com.ams.jdbcdebug.util.ConCheckTask;
import ams.com.ams.jdbcdebug.util.ConnectionDtl;
import ams.com.ams.jdbcdebug.util.Log;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;

public final class ConCheckMgr {
    private static HashMap conMap = new HashMap();

    static {
        if (ConCheckTask.INTERVAL_TIME > 0L) {
            Timer timer = new Timer();
            timer.schedule((TimerTask)new ConCheckTask(), 1000L, ConCheckTask.INTERVAL_TIME);
        }
    }

    public static void addChecker(Connection con) {
        conMap.put(con.toString(), new ConnectionDtl(con));
    }

    public static void removeChecker(Connection con) {
        conMap.remove(con.toString());
    }

    public static void closed(Connection rcon) {
        if (conMap.containsKey(rcon.toString())) {
            ConnectionDtl dtl = (ConnectionDtl)conMap.get(rcon.toString());
            conMap.remove(rcon.toString());
            dtl.setCon(null);
        } else {
            Log.println("[ConCheck] closed connection which jdbc debugger not checked.");
        }
    }

    public static HashMap getConMap() {
        return conMap;
    }
}

