/*
 * Decompiled with CFR 0.152.
 */
package jp.co.powerbeans.jdbcdebug.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Iterator;
import jp.co.powerbeans.jdbcdebug.util.Log;
import jp.co.powerbeans.jdbcdebug.util.Survey;

public class Statement
implements java.sql.Statement {
    java.sql.Statement st;
    private ArrayList batchSqlList = new ArrayList();

    Statement(java.sql.Statement statement) {
        this.st = statement;
    }

    private Statement() {
    }

    public void addBatch(String sql) throws SQLException {
        this.st.addBatch(sql);
        this.batchSqlList.add(sql);
    }

    public void cancel() throws SQLException {
        this.st.cancel();
    }

    public void clearBatch() throws SQLException {
        this.st.clearBatch();
        this.batchSqlList.clear();
    }

    public void clearWarnings() throws SQLException {
        this.st.clearWarnings();
    }

    public void close() throws SQLException {
        this.st.close();
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            Survey s = new Survey();
            boolean r = this.st.execute(sql, autoGeneratedKeys);
            Log.printlnSqlLog("execute " + sql, s.doEnd());
            return r;
        }
        catch (SQLException e) {
            Log.printlnSqlExceptionLog("execute " + sql, e);
            throw e;
        }
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            Survey s = new Survey();
            boolean r = this.st.execute(sql, columnIndexes);
            Log.printlnSqlLog("execute " + sql, s.doEnd());
            return r;
        }
        catch (SQLException e) {
            Log.printlnSqlExceptionLog("execute " + sql, e);
            throw e;
        }
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            Survey s = new Survey();
            boolean r = this.st.execute(sql, columnNames);
            Log.printlnSqlLog("execute " + sql, s.doEnd());
            return r;
        }
        catch (SQLException e) {
            Log.printlnSqlExceptionLog("execute " + sql, e);
            throw e;
        }
    }

    public boolean execute(String sql) throws SQLException {
        try {
            Survey s = new Survey();
            boolean r = this.st.execute(sql);
            Log.printlnSqlLog("execute " + sql, s.doEnd());
            return r;
        }
        catch (SQLException e) {
            Log.printlnSqlExceptionLog("execute" + sql, e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        try {
            try {
                Survey s = new Survey();
                int[] c = this.st.executeBatch();
                int i = 0;
                Iterator it = this.batchSqlList.iterator();
                while (true) {
                    if (!it.hasNext()) {
                        int[] nArray = c;
                        Object var5_7 = null;
                        this.batchSqlList.clear();
                        return nArray;
                    }
                    Log.printlnSqlLog("executeBatch " + it.next() + ", result " + c[i], s.doEnd());
                    ++i;
                }
            }
            catch (SQLException e) {
                Log.printlnSqlExceptionLog("executeBatch ", e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.batchSqlList.clear();
            throw throwable;
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            Survey s = new Survey();
            ResultSet r = this.st.executeQuery(sql);
            Log.printlnSqlLog("executeQuery " + sql, s.doEnd());
            return r;
        }
        catch (SQLException e) {
            Log.printlnSqlExceptionLog("executeQuery " + sql, e);
            throw e;
        }
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            Survey s = new Survey();
            int r = this.st.executeUpdate(sql, autoGeneratedKeys);
            Log.printlnSqlLog("executeUpdate " + sql, s.doEnd());
            return r;
        }
        catch (SQLException e) {
            Log.printlnSqlExceptionLog("executeUpdate " + sql, e);
            throw e;
        }
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            Survey s = new Survey();
            int r = this.st.executeUpdate(sql, columnIndexes);
            Log.printlnSqlLog("executeUpdate " + sql, s.doEnd());
            return r;
        }
        catch (SQLException e) {
            Log.printlnSqlExceptionLog("executeUpdate " + sql, e);
            throw e;
        }
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            Survey s = new Survey();
            int r = this.st.executeUpdate(sql, columnNames);
            Log.printlnSqlLog("executeUpdate " + sql, s.doEnd());
            return r;
        }
        catch (SQLException e) {
            Log.printlnSqlExceptionLog("executeUpdate " + sql, e);
            throw e;
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        try {
            Survey s = new Survey();
            int r = this.st.executeUpdate(sql);
            Log.printlnSqlLog("executeUpdate " + sql, s.doEnd());
            return r;
        }
        catch (SQLException e) {
            Log.printlnSqlExceptionLog("executeUpdate " + sql, e);
            throw e;
        }
    }

    public Connection getConnection() throws SQLException {
        return this.st.getConnection();
    }

    public int getFetchDirection() throws SQLException {
        return this.st.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.st.getFetchSize();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.st.getGeneratedKeys();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.st.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        return this.st.getMaxRows();
    }

    public boolean getMoreResults() throws SQLException {
        return this.st.getMoreResults();
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.st.getMoreResults();
    }

    public int getQueryTimeout() throws SQLException {
        return this.st.getQueryTimeout();
    }

    public ResultSet getResultSet() throws SQLException {
        return this.st.getResultSet();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.st.getResultSetConcurrency();
    }

    public int getResultSetHoldability() throws SQLException {
        return this.st.getResultSetHoldability();
    }

    public int getResultSetType() throws SQLException {
        return this.st.getResultSetType();
    }

    public int getUpdateCount() throws SQLException {
        return this.st.getUpdateCount();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.st.getWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        this.st.setCursorName(name);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.st.setEscapeProcessing(enable);
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.st.setFetchDirection(direction);
    }

    public void setFetchSize(int rows) throws SQLException {
        this.st.setFetchSize(rows);
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.st.setMaxFieldSize(max);
    }

    public void setMaxRows(int max) throws SQLException {
        this.st.setMaxRows(max);
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.st.setQueryTimeout(seconds);
    }
}

