/*
 * Decompiled with CFR 0.152.
 */
package jp.co.powerbeans.jdbcdebug.util;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import jp.co.powerbeans.jdbcdebug.sql.Driver;
import jp.co.powerbeans.jdbcdebug.util.ConCheckTask;
import jp.co.powerbeans.jdbcdebug.util.ConnectionDtl;
import jp.co.powerbeans.jdbcdebug.util.Log;

public final class ConCheckMgr {
    private static HashMap conMap = new HashMap();
    private static Timer checkTimer;

    public static void initTimer() {
        if (checkTimer != null) {
            return;
        }
        if (ConCheckTask.INTERVAL_TIME > 0L && ConCheckTask.OUTPUT_OVER_TIME > 0L) {
            checkTimer = new Timer();
            checkTimer.schedule((TimerTask)new ConCheckTask(), 1000L, ConCheckTask.INTERVAL_TIME);
            Log.println("start connection check timer. over=" + ConCheckTask.OUTPUT_OVER_TIME + " interval=" + ConCheckTask.INTERVAL_TIME + " " + Driver.getDriverInstance());
        }
    }

    public static void addChecker(Connection con) {
        if (con != null) {
            Log.println("addChecker " + con);
            conMap.put(con.toString(), new ConnectionDtl(con));
        }
    }

    public static void removeChecker(Connection con) {
        Log.println("removeChecker " + con);
        conMap.remove(con.toString());
    }

    public static void closed(Connection rcon) {
        Log.println("closed " + rcon);
        if (conMap.containsKey(rcon.toString())) {
            ConnectionDtl dtl = (ConnectionDtl)conMap.get(rcon.toString());
            conMap.remove(rcon.toString());
            dtl.setCon(null);
            Log.println("closed ok " + rcon);
        } else {
            Log.println("[ConCheck] closed connection which jdbc debugger not checked.");
        }
    }

    public static HashMap getConMap() {
        return conMap;
    }
}

