/*
 * Decompiled with CFR 0.152.
 */
package ams.com.ams.jdbcdebug.util;

import ams.com.ams.jdbcdebug.util.ConCheckMgr;
import ams.com.ams.jdbcdebug.util.ConnectionDtl;
import ams.com.ams.jdbcdebug.util.Log;
import java.util.ResourceBundle;
import java.util.TimerTask;

public class ConCheckTask
extends TimerTask {
    public static final long OUTPUT_OVER_TIME;
    public static final long INTERVAL_TIME;

    static {
        ResourceBundle bundle = ResourceBundle.getBundle("jdbcdebug");
        OUTPUT_OVER_TIME = Long.parseLong(bundle.getString("ConCheck.outputOverTime"));
        INTERVAL_TIME = Long.parseLong(bundle.getString("ConCheck.intervalTime"));
    }

    public void run() {
        String[] keys = ConCheckMgr.getConMap().keySet().toArray(new String[0]);
        long now = System.currentTimeMillis();
        Log.println("[ConCheck] connection check start. connection num " + keys.length);
        int i = 0;
        while (i < keys.length) {
            long delta;
            ConnectionDtl dtl = (ConnectionDtl)ConCheckMgr.getConMap().get(keys[i]);
            if (dtl != null && (delta = now - dtl.getConStartTime()) >= OUTPUT_OVER_TIME) {
                Log.println("[ConCheck] ### forgot to close connection? " + delta / 60000L + ":" + delta / 1000L % 60L + "sec   expired.\n" + dtl.getTrace());
            }
            ++i;
        }
    }
}

