/*
 * Decompiled with CFR 0.152.
 */
package ams.com.ams.jdbcdebug.util;

import ams.com.ams.jdbcdebug.sql.Driver;
import ams.com.ams.jdbcdebug.util.Survey;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.ResourceBundle;

public class Log {
    private static final String prefix;
    private static final int OUTTYPE_STDOUT = 1;
    private static final int OUTTYPE_FILE = 2;
    private static int outType;
    private static SimpleDateFormat df;
    private static final String LOG_FILE = "jdbcdebug.log";

    static {
        outType = 1;
        df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        ResourceBundle bundle = ResourceBundle.getBundle("jdbcdebug");
        try {
            outType = Integer.parseInt(bundle.getString("OutputType"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        prefix = bundle.getString(Driver.KEY_OUTPUT_PREFIX);
        Log.println("start");
    }

    private Log() {
    }

    public static void println(String string) {
        String outtext = String.valueOf(prefix) + " " + df.format(Calendar.getInstance().getTime()) + " " + string + "\n";
        Log.output(outtext);
    }

    private static void output(String outtext) {
        switch (outType) {
            case 2: {
                Log.outputFile(outtext);
                break;
            }
            default: {
                Log.outputStdout(outtext);
            }
        }
    }

    private static void outputStdout(String outtext) {
        System.out.print(outtext);
    }

    private static void outputFile(String outtext) {
        FileWriter fr = null;
        try {
            fr = new FileWriter(new File(LOG_FILE), true);
            fr.write(outtext);
            fr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void println(String string, Survey survey) {
        String outtext = String.valueOf(prefix) + " " + df.format(Calendar.getInstance().getTime()) + " " + (survey.getEndMs() - survey.getStartMs()) + "ms " + string + "\n";
        Log.output(outtext);
    }

    public static void println(String string, SQLException e) {
        String outtext = String.valueOf(prefix) + " " + df.format(Calendar.getInstance().getTime()) + " " + string + " [SQLException] " + e.getMessage() + "(" + e.getErrorCode() + ")" + "\n";
        Log.output(outtext);
    }

    public static void println(String string, Survey survey, HashMap paramMap) {
        String wstr = string;
        int q = 0;
        int paramIndex = 1;
        while ((q = wstr.indexOf(63, q)) != -1) {
            String paramIndexS = Integer.toString(paramIndex);
            if (paramMap.containsKey(paramIndexS)) {
                wstr = String.valueOf(wstr.substring(0, q)) + Log.encodeSqlField(paramMap.get(paramIndexS)) + wstr.substring(q + 1);
            }
            ++paramIndex;
        }
        Log.println(wstr, survey);
    }

    private static String encodeSqlField(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return "'" + object + "'";
        }
        return object.toString();
    }
}

