/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.jspc;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class EclipseJspCPlugin
extends AbstractUIPlugin {
    private static EclipseJspCPlugin plugin;
    private ResourceBundle resourceBundle;

    public EclipseJspCPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("resources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static EclipseJspCPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = EclipseJspCPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static String getShiftJISCodePage() {
        IPreferenceStore store = EclipseJspCPlugin.getDefault().getPreferenceStore();
        String p = store.getString("shiftjisPreference");
        if (p.equals("")) {
            return "MS932";
        }
        return p;
    }

    public static String getJspPackage() {
        IPreferenceStore store = EclipseJspCPlugin.getDefault().getPreferenceStore();
        String p = store.getString("packagePreference");
        if (p.equals("")) {
            return "org.apache.jsp";
        }
        return p;
    }

    public static String getOutputDir() {
        IPreferenceStore store = EclipseJspCPlugin.getDefault().getPreferenceStore();
        String p = store.getString("outputDirPreference");
        if (p.equals("")) {
            return "/tempjsp/org/apache/jsp";
        }
        return p;
    }
}

