/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.jspc.popup.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import jp.sourceforge.jeextension.jspc.EclipseJspCPlugin;
import jp.sourceforge.jeextension.jspc.Util;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class JspCRunner
implements IRunnableWithProgress {
    private Object element;
    Throwable occuredThrowable;

    public JspCRunner(Object selection) {
        this.element = selection;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.element instanceof IResource) {
            monitor.beginTask("JSP Compile Start.", 1);
            IResource resource = (IResource)this.element;
            File resourceFile = resource.getLocation().toFile();
            IProject project = resource.getProject();
            monitor.setTaskName("JSP Compiling.");
            monitor.worked(20);
            JspC jspc = new JspC();
            this.setupJspC(jspc, project, resourceFile);
            try {
                jspc.execute();
            }
            catch (JasperException e) {
                e.printStackTrace();
                e.getRootCause().printStackTrace();
                this.occuredThrowable = e;
            }
            monitor.setTaskName("Refresh Local Resources.");
            monitor.worked(70);
            try {
                project.refreshLocal(2, monitor);
                project.build(10, monitor);
            }
            catch (CoreException coreException) {}
        } else {
            return;
        }
        monitor.done();
    }

    private void setupJspC(JspC jspC, IProject project, File resourceFile) {
        String location = project.getLocation().toFile().getPath();
        String uriRoot = resourceFile.getPath();
        String outputDir = EclipseJspCPlugin.getOutputDir();
        String pkgName = EclipseJspCPlugin.getJspPackage();
        String encoding = ResourcesPlugin.getEncoding();
        jspC.setUriroot(uriRoot);
        jspC.setOutputDir(String.valueOf(location) + outputDir);
        jspC.setPackage(pkgName);
        jspC.setJavaEncoding(encoding);
        jspC.setClassPath(Util.getProjectClassPath(project));
    }
}

