/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.jspc/src/jp/sourceforge/jeextension/jspc/Util.java,v 1.2 2004/05/08 08:25:26 kohnosuke Exp $
 * $Revision: 1.2 $
 * $Date: 2004/05/08 08:25:26 $
 * ============================================================================
 * ***************************************************************************/

package jp.sourceforge.jeextension.jspc;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;

/**
 * Util
 */
public class Util {
    /**
     * Return project class-path.
     * @param project
     * @return
     */
    public static String getProjectClassPath(IProject project) {
        String classPath = "";
        try {
            String[] cp = JavaRuntime.computeDefaultRuntimeClassPath(
                                    JavaCore.create(project));
            for (int i = 0; i < cp.length; i++) {
                classPath = classPath + cp[i] + ";";
            }
        } catch (CoreException e) {
            e.printStackTrace();
        }
        return classPath;
    }
}
