/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.jspc/src/jp/sourceforge/jeextension/jspc/preferences/JspCPreferencePage.java,v 1.3 2004/05/08 08:25:26 kohnosuke Exp $
 * $Revision: 1.3 $
 * $Date: 2004/05/08 08:25:26 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.jspc.preferences;

import org.eclipse.jface.preference.*;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbench;

import jp.sourceforge.jeextension.jspc.EclipseJspCPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */

public class JspCPreferencePage extends FieldEditorPreferencePage
	   implements IWorkbenchPreferencePage {
	
    public static final String P_OUTPUT_DIR = "outputDirPreference";
	
    public static final String P_PACKAGE = "packagePreference";
	
    public static final String P_SHIFTJIS = "shiftjisPreference";

    public static final String DEFAULT_OUTPUT_DIR = "/tempjsp/org/apache/jsp";
    
    public static final String DEFAULT_PACKAGE = "org.apache.jsp";
    
    public static final String DEFAULT_SHIFTJIS = "MS932";

	public JspCPreferencePage() {
		super(GRID);
		setPreferenceStore(EclipseJspCPlugin.getDefault().getPreferenceStore());
		setDescription("Eclipse Extension Plug-in Project. 'Eclipse JspC' Setting.");
		initializeDefaults();
	}
    
    /**
     * Sets the default values of the preferences.
     */
	private void initializeDefaults() {
		IPreferenceStore store = getPreferenceStore();
		store.setDefault(P_OUTPUT_DIR, DEFAULT_OUTPUT_DIR);
		store.setDefault(P_PACKAGE, DEFAULT_PACKAGE);
		store.setDefault(P_SHIFTJIS, DEFAULT_SHIFTJIS);
	}
	
    /**
     * Creates the field editors. Field editors are abstractions of
     * the common GUI blocks needed to manipulate various types
     * of preferences. Each field editor knows how to save and
     * restore itself.
     */
	public void createFieldEditors() {
        addField(new StringFieldEditor(
                P_OUTPUT_DIR, 
                EclipseJspCPlugin.getResourceString("pref.page.outputdir"),
                getFieldEditorParent()));
        addField(new StringFieldEditor(
                P_PACKAGE, 
                EclipseJspCPlugin.getResourceString("pref.page.package"),
                getFieldEditorParent()));
		addField(new StringFieldEditor(
                P_SHIFTJIS, 
                EclipseJspCPlugin.getResourceString("pref.page.shiftjis"),
                getFieldEditorParent()));
	}
	
	public void init(IWorkbench workbench) {
	}
}