/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.common.xml;

import java.io.File;
import jp.sourceforge.jeextension.common.xml.XMLException;
import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.common.xml.XMLReader;
import jp.sourceforge.jeextension.common.xml.XMLWriter;
import org.w3c.dom.Document;

public class XMLFile {
    protected File currentFile;

    public XMLFile(String string) {
        this(new File(string.replace('/', File.separatorChar)));
    }

    public XMLFile(File file) {
        this.currentFile = file;
        if (this.currentFile.isDirectory()) {
            throw new IllegalArgumentException(file.getPath() + " isn't File object." + " can't initiate except file path.");
        }
    }

    public File getFile() {
        return this.currentFile;
    }

    public void writeDocument(Document document) throws XMLException {
        XMLWriter xMLWriter = new XMLWriter();
        xMLWriter.write(this.currentFile, document);
    }

    public void writeNode(XMLNode xMLNode) throws XMLException {
        XMLWriter xMLWriter = new XMLWriter();
        xMLWriter.write(this.currentFile, xMLNode);
    }

    public XMLNode readNode() throws XMLException {
        XMLReader xMLReader = new XMLReader();
        return xMLReader.readAsXMLNode(this.currentFile);
    }

    public Document readDocument() throws XMLException {
        XMLReader xMLReader = new XMLReader();
        return xMLReader.readAsDocument(this.currentFile);
    }
}

