/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.cpupdate.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.jeextension.common.xml.XMLException;
import jp.sourceforge.jeextension.common.xml.XMLFile;
import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.common.xml.XMLNodeList;
import jp.sourceforge.jeextension.cpupdate.CpUpdatePlugin;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.operation.IRunnableWithProgress;

class CpUpdateRunner
implements IRunnableWithProgress {
    private Object[] elements;
    private IProject currentProject;
    private IProgressMonitor currentMonitor;

    public CpUpdateRunner(Object[] selection) {
        this.elements = selection;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.currentMonitor = monitor;
        int i = 0;
        while (i < this.elements.length) {
            XMLNode rootNode;
            Object elem = this.elements[i];
            if (elem instanceof IProject) {
                this.currentProject = (IProject)elem;
            } else if (elem instanceof IJavaProject) {
                this.currentProject = ((IJavaProject)elem).getProject();
            } else {
                return;
            }
            File f = CpUpdatePlugin.getReferenceFile(this.currentProject);
            if (f == null) {
                return;
            }
            XMLFile xmlFile = new XMLFile(f);
            try {
                rootNode = xmlFile.readNode();
            }
            catch (XMLException e) {
                CpUpdatePlugin.log(e);
                return;
            }
            try {
                XMLNodeList nodeList = rootNode.getChildNodes();
                int j = 0;
                while (j < nodeList.size()) {
                    XMLNode node = nodeList.getNode(j);
                    if (node.getNodeName().equals("link-resource")) {
                        this.createLinkResource(node);
                    }
                    if (node.getNodeName().equals("output-folder")) {
                        this.createOutputFolder(node);
                    }
                    if (node.getNodeName().equals("classpath-entry")) {
                        this.createClasspath(node);
                    }
                    ++j;
                }
            }
            catch (CoreException e) {
                CpUpdatePlugin.log(e);
                return;
            }
            ++i;
        }
    }

    private void createLinkResource(XMLNode parent) throws CoreException {
        XMLNodeList nodeList = parent.getChildNodes();
        int i = 0;
        while (i < nodeList.size()) {
            XMLNode node = nodeList.getNode(i);
            String name = node.getAttribute("name");
            String path = node.getAttribute("path");
            IFolder folder = this.currentProject.getFolder(name);
            Path fullPath = new Path(path);
            fullPath.toFile().mkdirs();
            if (!folder.isLinked()) {
                folder.createLink((IPath)fullPath, 0, this.currentMonitor);
            }
            ++i;
        }
    }

    private void createOutputFolder(XMLNode parent) throws CoreException {
        XMLNodeList nodeList = parent.getChildNodes();
        int i = 0;
        while (i < nodeList.size()) {
            XMLNode node = nodeList.getNode(i);
            String name = node.getAttribute("name");
            IJavaProject javaProject = JavaCore.create((IProject)this.currentProject);
            IPath path = this.currentProject.getFullPath().append(name);
            javaProject.setOutputLocation(path, this.currentMonitor);
            ++i;
        }
    }

    private void createClasspath(XMLNode parent) throws CoreException {
        ArrayList entryList = new ArrayList();
        XMLNodeList nodeList = parent.getChildNodes();
        int i = 0;
        while (i < nodeList.size()) {
            String path;
            XMLNode node = nodeList.getNode(i);
            String kind = node.getAttribute("kind");
            if (kind.equals("src")) {
                String name = node.getAttribute("path");
                String output = node.getAttribute("output");
                this.addSourceFolder(name, output, entryList);
            }
            if (kind.equals("lib")) {
                path = node.getAttribute("path");
                String src = node.getAttribute("sourcepath");
                this.addLibraries(path, src, entryList);
            }
            if (kind.equals("con")) {
                path = node.getAttribute("path");
                this.addContainer(path, entryList);
            }
            ++i;
        }
        IJavaProject javaProject = JavaCore.create((IProject)this.currentProject);
        IClasspathEntry[] entries = entryList.toArray(new IClasspathEntry[entryList.size()]);
        javaProject.setRawClasspath(entries, this.currentMonitor);
    }

    protected void addSourceFolder(String name, String out, List list) throws CoreException {
        IPath path = this.currentProject.getFullPath().append(name);
        IPath output = null;
        if (out != null && !out.equals("")) {
            output = this.currentProject.getFullPath().append(out);
        }
        this.ensureFolderExists(path);
        IClasspathEntry entry = JavaCore.newSourceEntry((IPath)path, (IPath[])new IPath[0], output);
        list.add(entry);
    }

    protected void addLibraries(String lib, String src, List list) {
        IResource srcResource;
        Object srcPath;
        IResource libResource = this.currentProject.findMember(lib);
        Object libPath = libResource == null ? new Path(lib) : libResource.getFullPath();
        IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)libPath, srcPath = src == null || src.equals("") ? null : ((srcResource = this.currentProject.findMember(lib)) == null ? new Path(lib) : srcResource.getFullPath()), null, (boolean)false);
        if (entry != null) {
            list.add(entry);
        }
    }

    protected void addContainer(String name, List list) {
        list.add(JavaCore.newContainerEntry((IPath)new Path(name)));
    }

    private void ensureFolderExists(IPath folderPath) throws CoreException {
        IWorkspace workspace = this.currentProject.getWorkspace();
        int i = 1;
        while (i <= folderPath.segmentCount()) {
            IPath partialPath = folderPath.uptoSegment(i);
            if (!workspace.getRoot().exists(partialPath)) {
                IFolder folder = workspace.getRoot().getFolder(partialPath);
                folder.create(true, true, this.currentMonitor);
            }
            ++i;
        }
    }
}

