/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.cpupdate.properties;

import jp.sourceforge.jeextension.common.plugin.properties.DefaultPropertyPage;
import jp.sourceforge.jeextension.common.xml.XMLException;
import jp.sourceforge.jeextension.common.xml.XMLFile;
import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.common.xml.XMLNodeList;
import jp.sourceforge.jeextension.cpupdate.CpUpdatePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CpUpdatePropertyPage
extends DefaultPropertyPage {
    public static final String KEY_DEFFILE = "cpu.def.file.name";
    private Button fButton;
    private Text fText;

    public CpUpdatePropertyPage() {
        this.setTitle(this.getMessage("property.page.title"));
        this.setDescription(this.getMessage("property.page.description"));
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText(this.getMessage("property.page.label"));
        this.fText = new Text(composite, 2048);
        this.fText.setLayoutData((Object)new GridData(768));
        this.fButton = new Button(composite, 0);
        this.fButton.setText(this.getMessage("property.page.button"));
        this.fButton.addListener(13, (Listener)this);
        try {
            IJavaProject element = (IJavaProject)this.getElement();
            String prop = CpUpdatePlugin.load(element.getProject());
            if (prop != null) {
                this.fText.setText(prop);
            }
        }
        catch (XMLException e) {
            CpUpdatePlugin.log(e);
        }
        return composite;
    }

    public void handleEvent(Event event) {
        FileDialog fd = new FileDialog(this.getShell());
        fd.setFilterExtensions(new String[]{"*.xml"});
        fd.setText(this.fText.getText());
        String path = fd.open();
        if (path != null) {
            if (this.validateReferenceFile(path)) {
                this.fText.setText(path);
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)this.getMessage("property.page.error.title"), (String)this.getMessage("property.page.error.message"));
            }
        }
    }

    private boolean validateReferenceFile(String path) {
        XMLNode rootNode;
        XMLFile xmlFile = new XMLFile(path);
        try {
            rootNode = xmlFile.readNode();
        }
        catch (XMLException e) {
            CpUpdatePlugin.log(e);
            return false;
        }
        XMLNodeList nodeList = rootNode.getChildNodes();
        int i = 0;
        while (i < nodeList.size()) {
            XMLNode node = nodeList.getNode(i);
            if (node.getNodeName().equals("format-version") && node.getNodeValue().equals("1.0")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void performDefaults() {
        this.fText.setText("");
    }

    public boolean performOk() {
        try {
            IJavaProject element = (IJavaProject)this.getElement();
            CpUpdatePlugin.save(element.getProject(), this.fText.getText());
            element.getProject().refreshLocal(2, null);
        }
        catch (CoreException coreException) {
            return false;
        }
        catch (XMLException xMLException) {
            return false;
        }
        return true;
    }
}

