/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.cpupdate/src/jp/sourceforge/jeextension/cpupdate/CpUpdatePlugin.java,v 1.1 2004/12/17 02:18:08 kohnosuke Exp $
 * $Revision: 1.1 $
 * $Date: 2004/12/17 02:18:08 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.cpupdate;

import java.io.File;
import java.io.IOException;

import jp.sourceforge.jeextension.common.xml.XMLException;
import jp.sourceforge.jeextension.common.xml.XMLFile;
import jp.sourceforge.jeextension.common.xml.XMLNode;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/**
 * The main plugin class to be used in the desktop.
 */
public class CpUpdatePlugin extends AbstractUIPlugin {
    
    /** The shared instance. */
    private static CpUpdatePlugin plugin;

    /**
     * Returns the shared instance.
     * @return the shared instance.
     */
    public static CpUpdatePlugin getDefault() {
        return plugin;
    }
    
    /**
     * Returns reference file object that setting at property page.
     * if value is empty, return null.
     * @param project current project IResource object.
     * @return value or null.
     */
    public static File getReferenceFile(IProject project) {
        File file = null;
        try {
            String path = load(project);
            if (path != null && path.equals("") == false) {
                file = new File(path);
            }
        }
        catch (XMLException e) {
            log(e);
        }
        return file;
    }
    
    /**
     * Save property page values.
     * @param project target's project.
     * @param path value.
     * @throws XMLException throws failed when write xml file.
     */
    public static void save(IProject project, String path)
            throws XMLException {
        XMLNode root = new XMLNode("jee-cp");
        XMLNode node = new XMLNode("reference-file");
        node.setNodeValue(path);
        root.addChild(node);
        
        IFile file = project.getFile(".jee-cp");
        
        try {
            File f = file.getLocation().toFile();
            if (f.exists() == false) {
                f.createNewFile();
            }
            XMLFile xmlFile = new XMLFile(f);
            xmlFile.writeNode(root);
        }
        catch (IOException e) {
            log(e);
        }
        catch (XMLException e) {
            log(e);
        }
    }
    
    /**
     * Load property page values.
     * @param project target's project.
     * @return value.
     * @throws XMLException throws failed when read xml file.
     */
    public static String load(IProject project) throws XMLException {
        IFile file = project.getFile(".jee-cp");
        if (file.exists() == false) {
            return null;
        }
        XMLFile xmlFile = new XMLFile(file.getLocation().toFile());
        String path = null;
        XMLNode root = xmlFile.readNode();
        path = root.getChildNodes().getNode(0).getNodeValue();
        return path;
    }

    /**
     * log the plugin error log using Throwable.
     * @param e Throwable object.
     */
    public static void log(Throwable e) {
        ILog log = getDefault().getLog();
        String pluginId = getDefault().getDescriptor().getUniqueIdentifier();
        log.log(
            new Status(IStatus.ERROR, pluginId, 10001, "internal_error", e));
    }

    /**
     * The constructor.
     * @param descriptor IPluginDescriptor.
     */
    public CpUpdatePlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }
}
