/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.cpupdate/src/jp/sourceforge/jeextension/cpupdate/actions/CpUpdateAction.java,v 1.1 2004/12/17 02:18:08 kohnosuke Exp $
 * $Revision: 1.1 $
 * $Date: 2004/12/17 02:18:08 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.cpupdate.actions;

import java.lang.reflect.InvocationTargetException;

import jp.sourceforge.jeextension.cpupdate.CpUpdatePlugin;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class CpUpdateAction implements IWorkbenchWindowActionDelegate {

    /**
     * Selected resource.
     */
    private ISelection fSelection;

    /**
     * {@inheritDoc}
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        
        if ((fSelection instanceof IStructuredSelection) == false) {
            return;
        }
        Object[] element =  ((IStructuredSelection) fSelection).toArray();
        
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(null);
        CpUpdateRunner runnable = new CpUpdateRunner(element);
        
        try {
            dialog.run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            CpUpdatePlugin.log(e);
        }
        catch (InterruptedException e) {
            CpUpdatePlugin.log(e);
        }
    }

    /**
     * {@inheritDoc}
     * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
     */
    public void dispose() {
    }

    /**
     * {@inheritDoc}
     * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#init(org.eclipse.ui.IWorkbenchWindow)
     */
    public void init(IWorkbenchWindow window) {
    }

    /**
     * {@inheritDoc}
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
        fSelection = selection;
    }
}
