/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.cpupdate/src/jp/sourceforge/jeextension/cpupdate/properties/CpUpdatePropertyPage.java,v 1.2 2004/12/17 07:30:07 kohnosuke Exp $
 * $Revision: 1.2 $
 * $Date: 2004/12/17 07:30:07 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.cpupdate.properties;

import jp.sourceforge.jeextension.common.plugin.properties.DefaultPropertyPage;
import jp.sourceforge.jeextension.common.xml.XMLException;
import jp.sourceforge.jeextension.common.xml.XMLFile;
import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.common.xml.XMLNodeList;
import jp.sourceforge.jeextension.cpupdate.CpUpdatePlugin;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;

public class CpUpdatePropertyPage extends DefaultPropertyPage {
    
    /** PersistentProperty key name. */
    public static final String KEY_DEFFILE = "cpu.def.file.name";

    /**
     * Reference Button.
     */
    private Button fButton;

    /**
     * Reference File Text.
     */
    private Text fText;

    /**
     * Constructor for SamplePropertyPage.
     */
    public CpUpdatePropertyPage() {
        super();
        setTitle(getMessage("property.page.title"));
        setDescription(getMessage("property.page.description"));
    }

    /**
     * @see PreferencePage#createContents(Composite)
     */
    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, SWT.NONE);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout(gridLayout);

        Label label = new Label(composite, SWT.NONE);
        label.setText(getMessage("property.page.label"));

        fText = new Text(composite, SWT.BORDER);
        fText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

        fButton = new Button(composite, SWT.NONE);
        fButton.setText(getMessage("property.page.button"));
        fButton.addListener(SWT.Selection, this);

        // load setting.
        try {
            IJavaProject element = (IJavaProject) getElement();
            String prop = CpUpdatePlugin.load(element.getProject());
            if (prop != null) {
                fText.setText(prop);
            }
        }
        catch (XMLException e) {
            CpUpdatePlugin.log(e);
        }

        return composite;
    }

    /**
     * {@inheritDoc}
     * @see org.eclipse.swt.widgets.Listener#handleEvent(org.eclipse.swt.widgets.Event)
     */
    public void handleEvent(Event event) {
        FileDialog fd = new FileDialog(getShell());
        fd.setFilterExtensions(new String[] {
                "*.xml",
            }
        );
        fd.setText(fText.getText());
        String path = fd.open();
        if (path != null) {
            if (validateReferenceFile(path)) {
                fText.setText(path);
            }
            else {
                MessageDialog.openError(getShell(),
                        getMessage("property.page.error.title"),
                        getMessage("property.page.error.message"));
            }
        }
    }

    /**
     * Check reference file format validation.
     * @param path reference file path.
     * @return true or false. validation results.
     */
    private boolean validateReferenceFile(String path) {
        
        // try read.
        XMLFile xmlFile = new XMLFile(path);
        XMLNode rootNode;
        try {
            rootNode = xmlFile.readNode();
        }
        catch (XMLException e) {
            CpUpdatePlugin.log(e);
            return false;
        }
        
        // check format-version.
        XMLNodeList nodeList = rootNode.getChildNodes();
        for (int i = 0; i < nodeList.size(); i++) {
            XMLNode node = nodeList.getNode(i);
            if (node.getNodeName().equals("format-version")) {
                if (node.getNodeValue().equals("1.0")) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * {@inheritDoc}
     * @see org.eclipse.jface.preference.PreferencePage#performDefaults()
     */
    protected void performDefaults() {
        // Populate the text field with the default value
        fText.setText("");
    }

    /**
     * {@inheritDoc}
     * @see org.eclipse.jface.preference.IPreferencePage#performOk()
     */
    public boolean performOk() {
        // store the value in the text field
        try {
            IJavaProject element = (IJavaProject) getElement();
            CpUpdatePlugin.save(element.getProject(), fText.getText());
            element.getProject().refreshLocal(IResource.DEPTH_INFINITE, null);
        }
        catch (CoreException e) {
            return false;
        }
        catch (XMLException e) {
            return false;
        }
        return true;
    }
}