/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TableEditor
extends ControlEditor {
    Table table;
    TableItem item;
    int column = -1;
    Listener columnListener;

    public TableEditor(Table table) {
        super(table);
        this.table = table;
        this.columnListener = new Listener(){

            public void handleEvent(Event e) {
                TableEditor.this.resize();
            }
        };
    }

    Rectangle computeBounds() {
        if (this.item == null || this.column == -1 || this.item.isDisposed()) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle cell = this.item.getBounds(this.column);
        Rectangle editorRect = new Rectangle(cell.x, cell.y, this.minimumWidth, cell.height);
        Rectangle area = this.table.getClientArea();
        if (cell.x < area.x + area.width && cell.x + cell.width > area.x + area.width) {
            cell.width = area.width - cell.x;
        }
        if (this.grabHorizontal) {
            editorRect.width = Math.max(cell.width, this.minimumWidth);
        }
        if (this.horizontalAlignment == 131072) {
            editorRect.x += cell.width - editorRect.width;
        } else if (this.horizontalAlignment != 16384) {
            editorRect.x += (cell.width - editorRect.width) / 2;
        }
        return editorRect;
    }

    public void dispose() {
        if (this.column > -1 && this.column < this.table.getColumnCount()) {
            TableColumn tableColumn = this.table.getColumn(this.column);
            tableColumn.removeListener(11, this.columnListener);
            tableColumn.removeListener(10, this.columnListener);
        }
        this.columnListener = null;
        this.table = null;
        this.item = null;
        this.column = -1;
        super.dispose();
    }

    public int getColumn() {
        return this.column;
    }

    public TableItem getItem() {
        return this.item;
    }

    public void setColumn(int column) {
        TableColumn tableColumn;
        int columnCount = this.table.getColumnCount();
        if (columnCount == 0) {
            this.column = column == 0 ? 0 : -1;
            this.resize();
            return;
        }
        if (this.column > -1 && this.column < columnCount) {
            tableColumn = this.table.getColumn(this.column);
            tableColumn.removeListener(11, this.columnListener);
            tableColumn.removeListener(10, this.columnListener);
            this.column = -1;
        }
        if (column < 0 || column >= this.table.getColumnCount()) {
            return;
        }
        this.column = column;
        tableColumn = this.table.getColumn(this.column);
        tableColumn.addListener(11, this.columnListener);
        tableColumn.addListener(10, this.columnListener);
        this.resize();
    }

    public void setItem(TableItem item) {
        this.item = item;
        this.resize();
    }

    public void setEditor(Control editor, TableItem item, int column) {
        this.setItem(item);
        this.setColumn(column);
        this.setEditor(editor);
    }

    void resize() {
        if (this.table.isDisposed()) {
            return;
        }
        if (this.item == null || this.item.isDisposed()) {
            return;
        }
        int columnCount = this.table.getColumnCount();
        if (columnCount == 0 && this.column != 0) {
            return;
        }
        if (columnCount > 0 && (this.column < 0 || this.column >= columnCount)) {
            return;
        }
        super.resize();
    }
}

