/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TCITEM;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;

public class TabFolder
extends Composite {
    TabItem[] items;
    ImageList imageList;
    static final int TabFolderProc;
    static final TCHAR TabFolderClass;
    static final int ID_UPDOWN = 1;

    static {
        TabFolderClass = new TCHAR(0, "SWT_SysTabControl32", true);
        WNDCLASS lpWndClass = new WNDCLASS();
        TCHAR WC_TABCONTROL = new TCHAR(0, "SysTabControl32", true);
        OS.GetClassInfo(0, WC_TABCONTROL, lpWndClass);
        TabFolderProc = lpWndClass.lpfnWndProc;
        int hInstance = OS.GetModuleHandle(null);
        if (!OS.GetClassInfo(hInstance, TabFolderClass, lpWndClass)) {
            int hHeap = OS.GetProcessHeap();
            lpWndClass.hInstance = hInstance;
            lpWndClass.style &= 0xFFFFFFFC;
            int byteCount = TabFolderClass.length() * TCHAR.sizeof;
            int lpszClassName = OS.HeapAlloc(hHeap, 8, byteCount);
            OS.MoveMemory(lpszClassName, TabFolderClass, byteCount);
            lpWndClass.lpszClassName = lpszClassName;
            OS.RegisterClass(lpWndClass);
        }
    }

    public TabFolder(Composite parent, int style) {
        super(parent, TabFolder.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int msg, int wParam, int lParam) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(TabFolderProc, this.handle, msg, wParam, lParam);
    }

    static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        RECT insetRect = new RECT();
        RECT itemRect = new RECT();
        OS.SendMessage(this.handle, 4904, 0, insetRect);
        int width = insetRect.left - insetRect.right;
        int height = 0;
        int count = OS.SendMessage(this.handle, 4868, 0, 0);
        if (count != 0) {
            OS.SendMessage(this.handle, 4874, count - 1, itemRect);
            width = Math.max(width, itemRect.right - insetRect.right);
        }
        Point size = null;
        size = this.layout != null ? this.layout.computeSize(this, wHint, hHint, changed) : this.minimumSize(wHint, hHint, changed);
        if (size.x == 0) {
            size.x = 64;
        }
        if (size.y == 0) {
            size.y = 64;
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        width = Math.max(width, size.x);
        height = Math.max(height, size.y);
        Rectangle trim = this.computeTrim(0, 0, width, height);
        width = trim.width;
        height = trim.height;
        return new Point(width, height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        RECT rect = new RECT();
        OS.SetRect(rect, x, y, x + width, y + height);
        OS.SendMessage(this.handle, 4904, 1, rect);
        int border = this.getBorderWidth();
        rect.left -= border;
        rect.right += border;
        rect.top -= border;
        rect.bottom += border;
        int newWidth = rect.right - rect.left;
        int newHeight = rect.bottom - rect.top;
        return new Rectangle(rect.left, rect.top, newWidth, newHeight);
    }

    void createItem(TabItem item, int index) {
        TCITEM tcItem;
        int count = OS.SendMessage(this.handle, 4868, 0, 0);
        if (index < 0 || index > count) {
            this.error(6);
        }
        if (count == this.items.length) {
            TabItem[] newItems = new TabItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        if (OS.SendMessage(this.handle, OS.TCM_INSERTITEM, index, tcItem = new TCITEM()) == -1) {
            this.error(14);
        }
        System.arraycopy(this.items, index, this.items, index + 1, count - index);
        this.items[index] = item;
        if (count == 0) {
            Event event = new Event();
            event.item = this.items[0];
            this.sendEvent(13, event);
        }
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFEFFF;
        int hwndToolTip = OS.SendMessage(this.handle, 4909, 0, 0);
        OS.SendMessage(hwndToolTip, 1048, 0, Short.MAX_VALUE);
    }

    void createWidget() {
        super.createWidget();
        this.items = new TabItem[4];
    }

    void destroyItem(TabItem item) {
        int count = OS.SendMessage(this.handle, 4868, 0, 0);
        int index = 0;
        while (index < count) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == count) {
            return;
        }
        int selectionIndex = OS.SendMessage(this.handle, 4875, 0, 0);
        if (OS.SendMessage(this.handle, 4872, index, 0) == 0) {
            this.error(15);
        }
        System.arraycopy(this.items, index + 1, this.items, index, --count - index);
        this.items[count] = null;
        if (count == 0) {
            if (this.imageList != null) {
                OS.SendMessage(this.handle, 4867, 0, 0);
                Display display = this.getDisplay();
                display.releaseImageList(this.imageList);
            }
            this.imageList = null;
            this.items = new TabItem[4];
        }
        if (count > 0 && index == selectionIndex) {
            this.setSelection(Math.max(0, selectionIndex - 1));
            selectionIndex = this.getSelectionIndex();
            if (selectionIndex != -1) {
                Event event = new Event();
                event.item = this.items[selectionIndex];
                this.sendEvent(13, event);
            }
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        this.forceResize();
        RECT rect = new RECT();
        OS.GetClientRect(this.handle, rect);
        OS.SendMessage(this.handle, 4904, 0, rect);
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        return new Rectangle(rect.left, rect.top, width, height);
    }

    public TabItem getItem(int index) {
        this.checkWidget();
        int count = OS.SendMessage(this.handle, 4868, 0, 0);
        if (index < 0 || index >= count) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 4868, 0, 0);
    }

    public TabItem[] getItems() {
        this.checkWidget();
        int count = OS.SendMessage(this.handle, 4868, 0, 0);
        TabItem[] result = new TabItem[count];
        System.arraycopy(this.items, 0, result, 0, count);
        return result;
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        int index = OS.SendMessage(this.handle, 4875, 0, 0);
        if (index == -1) {
            return new TabItem[0];
        }
        return new TabItem[]{this.items[index]};
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 4875, 0, 0);
    }

    int imageIndex(Image image) {
        if (image == null) {
            return -2;
        }
        if (this.imageList == null) {
            Rectangle bounds = image.getBounds();
            this.imageList = this.getDisplay().getImageList(new Point(bounds.width, bounds.height));
            int index = this.imageList.indexOf(image);
            if (index == -1) {
                index = this.imageList.add(image);
            }
            int hImageList = this.imageList.getHandle();
            OS.SendMessage(this.handle, 4867, 0, hImageList);
            return index;
        }
        int index = this.imageList.indexOf(image);
        if (index != -1) {
            return index;
        }
        return this.imageList.add(image);
    }

    public int indexOf(TabItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        int count = OS.SendMessage(this.handle, 4868, 0, 0);
        int i = 0;
        while (i < count) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    Point minimumSize(int wHint, int hHint, boolean flushCache) {
        Control[] children = this._getChildren();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            int index = 0;
            int count = OS.SendMessage(this.handle, 4868, 0, 0);
            while (index < count) {
                if (this.items[index].control == child) break;
                ++index;
            }
            if (index == count) {
                Rectangle rect = child.getBounds();
                width = Math.max(width, rect.x + rect.width);
                height = Math.max(height, rect.y + rect.height);
            } else {
                Point size = child.computeSize(wHint, hHint, flushCache);
                width = Math.max(width, size.x);
                height = Math.max(height, size.y);
            }
            ++i;
        }
        return new Point(width, height);
    }

    boolean mnemonicHit(char key) {
        int i = 0;
        while (i < this.items.length) {
            TabItem item = this.items[i];
            if (item != null) {
                char ch = this.findMnemonic(item.getText());
                if (Character.toUpperCase(key) == Character.toUpperCase(ch) && this.setFocus()) {
                    this.setSelection(i, true);
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    boolean mnemonicMatch(char key) {
        int i = 0;
        while (i < this.items.length) {
            TabItem item = this.items[i];
            if (item != null) {
                char ch = this.findMnemonic(item.getText());
                if (Character.toUpperCase(key) == Character.toUpperCase(ch)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    void releaseWidget() {
        int count = OS.SendMessage(this.handle, 4868, 0, 0);
        int i = 0;
        while (i < count) {
            TabItem item = this.items[i];
            if (!item.isDisposed()) {
                item.releaseResources();
            }
            ++i;
        }
        this.items = null;
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 4867, 0, 0);
            Display display = this.getDisplay();
            display.releaseImageList(this.imageList);
        }
        this.imageList = null;
        super.releaseWidget();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setSelection(TabItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        if (items.length == 0) {
            this.setSelection(-1);
            return;
        }
        int i = items.length - 1;
        while (i >= 0) {
            int index = this.indexOf(items[i]);
            if (index != -1) {
                this.setSelection(index);
            }
            --i;
        }
    }

    public void setSelection(int index) {
        this.checkWidget();
        this.setSelection(index, false);
    }

    void setSelection(int index, boolean notify) {
        int oldIndex = OS.SendMessage(this.handle, 4875, 0, 0);
        if (oldIndex != -1) {
            TabItem item = this.items[oldIndex];
            Control control = item.control;
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
        }
        OS.SendMessage(this.handle, 4876, index, 0);
        int newIndex = OS.SendMessage(this.handle, 4875, 0, 0);
        if (newIndex != -1) {
            TabItem item = this.items[newIndex];
            Control control = item.control;
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
                control.setVisible(true);
            }
            if (notify) {
                Event event = new Event();
                event.item = item;
                this.sendEvent(13, event);
            }
        }
    }

    String toolTipText(NMTTDISPINFO hdr) {
        if ((hdr.uFlags & 1) != 0) {
            return null;
        }
        int index = hdr.idFrom;
        int hwndToolTip = OS.SendMessage(this.handle, 4909, 0, 0);
        if (hwndToolTip == hdr.hwndFrom) {
            TabItem item;
            if (this.toolTipText != null) {
                return "";
            }
            if (index >= 0 && index < this.items.length && (item = this.items[index]) != null) {
                return item.toolTipText;
            }
        }
        return super.toolTipText(hdr);
    }

    boolean traversePage(boolean next) {
        int count = this.getItemCount();
        if (count == 0) {
            return false;
        }
        int index = this.getSelectionIndex();
        if (index == -1) {
            index = 0;
        } else {
            int offset = next ? 1 : -1;
            index = (index + offset + count) % count;
        }
        this.setSelection(index, true);
        return index == this.getSelectionIndex();
    }

    int widgetStyle() {
        int bits = super.widgetStyle() | 0x2000000;
        if ((this.style & 0x80000) != 0) {
            bits |= 0x8000;
        }
        return bits | 0x4000;
    }

    TCHAR windowClass() {
        return TabFolderClass;
    }

    int windowProc() {
        return TabFolderProc;
    }

    LRESULT WM_GETDLGCODE(int wParam, int lParam) {
        LRESULT result = super.WM_GETDLGCODE(wParam, lParam);
        if (result != null) {
            return result;
        }
        return new LRESULT(8192);
    }

    LRESULT WM_NCHITTEST(int wParam, int lParam) {
        LRESULT result = super.WM_NCHITTEST(wParam, lParam);
        if (result != null) {
            return result;
        }
        int hittest = OS.DefWindowProc(this.handle, 132, wParam, lParam);
        return new LRESULT(hittest);
    }

    LRESULT WM_NOTIFY(int wParam, int lParam) {
        LRESULT result = super.WM_NOTIFY(wParam, lParam);
        if (result != null) {
            return result;
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_PARENTNOTIFY(int wParam, int lParam) {
        LRESULT result = super.WM_PARENTNOTIFY(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) < 262154) {
            return result;
        }
        if ((this.style & 0x4000000) != 0) {
            int code = wParam & 0xFFFF;
            switch (code) {
                case 1: {
                    int id = wParam >> 16;
                    int hwnd = lParam;
                    if (id != 1) break;
                    int bits = OS.GetWindowLong(hwnd, -20);
                    OS.SetWindowLong(hwnd, -20, bits | 0x400000);
                }
            }
        }
        return result;
    }

    LRESULT WM_SIZE(int wParam, int lParam) {
        LRESULT result = super.WM_SIZE(wParam, lParam);
        if (this.isDisposed()) {
            return result;
        }
        int index = OS.SendMessage(this.handle, 4875, 0, 0);
        if (index != -1) {
            TabItem item = this.items[index];
            Control control = item.control;
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
            }
        }
        return result;
    }

    LRESULT WM_WINDOWPOSCHANGING(int wParam, int lParam) {
        LRESULT result = super.WM_WINDOWPOSCHANGING(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return result;
        }
        WINDOWPOS lpwp = new WINDOWPOS();
        OS.MoveMemory(lpwp, lParam, 28);
        if ((lpwp.flags & 9) != 0) {
            return result;
        }
        int bits = OS.GetWindowLong(this.handle, -16);
        if ((bits & 0x200) != 0) {
            OS.InvalidateRect(this.handle, null, true);
            return result;
        }
        RECT rect = new RECT();
        OS.SetRect(rect, 0, 0, lpwp.cx, lpwp.cy);
        OS.SendMessage(this.handle, 131, 0, rect);
        int newWidth = rect.right - rect.left;
        int newHeight = rect.bottom - rect.top;
        OS.GetClientRect(this.handle, rect);
        int oldWidth = rect.right - rect.left;
        int oldHeight = rect.bottom - rect.top;
        if (newWidth == oldWidth && newHeight == oldHeight) {
            return result;
        }
        RECT inset = new RECT();
        OS.SendMessage(this.handle, 4904, 0, inset);
        int marginX = -inset.right;
        int marginY = -inset.bottom;
        if (newWidth != oldWidth) {
            int left = oldWidth;
            if (newWidth < oldWidth) {
                left = newWidth;
            }
            OS.SetRect(rect, left - marginX, 0, newWidth, newHeight);
            OS.InvalidateRect(this.handle, rect, true);
        }
        if (newHeight != oldHeight) {
            int bottom = oldHeight;
            if (newHeight < oldHeight) {
                bottom = newHeight;
            }
            if (newWidth < oldWidth) {
                oldWidth -= marginX;
            }
            OS.SetRect(rect, 0, bottom - marginY, oldWidth, newHeight);
            OS.InvalidateRect(this.handle, rect, true);
        }
        return result;
    }

    LRESULT wmNotifyChild(int wParam, int lParam) {
        NMHDR hdr = new NMHDR();
        OS.MoveMemory(hdr, lParam, 12);
        int code = hdr.code;
        switch (code) {
            case -552: 
            case -551: {
                Control control;
                TabItem item = null;
                int index = OS.SendMessage(this.handle, 4875, 0, 0);
                if (index != -1) {
                    item = this.items[index];
                }
                if (item != null && (control = item.control) != null && !control.isDisposed()) {
                    if (code == -551) {
                        control.setBounds(this.getClientArea());
                    }
                    control.setVisible(code == -551);
                }
                if (code != -551) break;
                Event event = new Event();
                event.item = item;
                this.postEvent(13, event);
            }
        }
        return super.wmNotifyChild(wParam, lParam);
    }
}

