/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.ControlCharRenderer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledTextBidi;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

abstract class StyledTextRenderer {
    private Device device;
    protected Font regularFont;
    protected Font boldFont;
    private boolean isBidi;
    private int leftMargin;
    private int tabLength;
    private int tabWidth;
    private int lineHeight;
    private int lineEndSpaceWidth;
    private int currentFontStyle = 0;

    StyledTextRenderer(Device device, Font font, boolean bl, int n) {
        FontData[] fontDataArray = font.getFontData();
        int n2 = 0;
        while (n2 < fontDataArray.length) {
            fontDataArray[n2].setStyle(fontDataArray[n2].getStyle() | 1);
            ++n2;
        }
        this.boldFont = new Font(device, fontDataArray);
        this.device = device;
        this.regularFont = font;
        this.isBidi = bl;
        this.leftMargin = n;
    }

    void calculateLineHeight() {
        GC gC = this.getGC();
        this.lineHeight = gC.getFontMetrics().getHeight();
        this.lineEndSpaceWidth = gC.stringExtent((String)" ").x;
        this.disposeGC(gC);
    }

    void dispose() {
        if (this.boldFont != null) {
            this.boldFont.dispose();
            this.boldFont = null;
        }
    }

    protected abstract void disposeGC(GC var1);

    void drawLine(String string, int n, int n2, GC gC, Color color, Color color2, boolean bl, ControlCharRenderer controlCharRenderer) {
        int n3 = this.getContent().getOffsetAtLine(n);
        int n4 = string.length();
        Point point = this.getSelection();
        int n5 = point.x;
        int n6 = point.y;
        StyleRange[] styleRangeArray = new StyleRange[]{};
        Color color3 = null;
        StyledTextEvent styledTextEvent = this.getLineStyleData(n3, string);
        StyledTextBidi styledTextBidi = null;
        if (styledTextEvent != null) {
            styleRangeArray = styledTextEvent.styles;
        }
        if (this.isBidi()) {
            this.setLineFont(gC, 0);
            styledTextBidi = this.getStyledTextBidi(string, n3, gC, styleRangeArray);
        }
        if ((styledTextEvent = this.getLineBackgroundData(n3, string)) != null) {
            color3 = styledTextEvent.lineBackground;
        }
        if (color3 == null) {
            color3 = color;
        }
        if (bl && (!this.isFullLineSelection() || n5 > n3 || n6 <= n3 + n4)) {
            gC.setBackground(color3);
            gC.setForeground(color3);
            gC.fillRectangle(this.leftMargin, n2, this.getClientArea().width, this.lineHeight);
        }
        if (n5 != n6) {
            this.drawLineBreakSelection(string, n3, styleRangeArray, n2, gC, styledTextBidi);
            if (n5 >= n3 && n5 < n3 + n4 || n5 < n3 && n6 > n3) {
                styleRangeArray = this.mergeSelectionLineStyles(styleRangeArray);
            }
        }
        this.drawStyledLine(string, n3, 0, styleRangeArray, 0, n2, gC, color3, color2, styledTextBidi, controlCharRenderer);
    }

    void drawLine(String string, int n, int n2, GC gC, Color color, Color color2, boolean bl) {
        this.drawLine(string, n, n2, gC, color, color2, bl, new ControlCharRenderer());
    }

    protected abstract void drawLineBreakSelection(String var1, int var2, StyleRange[] var3, int var4, GC var5, StyledTextBidi var6);

    private void drawStyledLine(String string, int n, int n2, StyleRange[] styleRangeArray, int n3, int n4, GC gC, Color color, Color color2, StyledTextBidi styledTextBidi, ControlCharRenderer controlCharRenderer) {
        int n5;
        int n6;
        int n7;
        int n8 = string.length();
        int n9 = this.getHorizontalPixel();
        Color color3 = gC.getBackground();
        Color color4 = gC.getForeground();
        StyleRange styleRange = null;
        StyleRange[] styleRangeArray2 = this.filterLineStyles(styleRangeArray);
        int n10 = this.getClientArea().width + n9;
        int n11 = 0;
        while (n11 < styleRangeArray.length && (n3 < n10 || styledTextBidi != null)) {
            block19: {
                block18: {
                    block17: {
                        styleRange = styleRangeArray[n11];
                        n7 = styleRange.start + styleRange.length - n;
                        n6 = Math.max(styleRange.start - n, 0);
                        if (n6 <= n2) break block17;
                        color3 = this.setLineBackground(gC, color3, color);
                        color4 = this.setLineForeground(gC, color4, color2);
                        this.setLineFont(gC, 0);
                        n6 = Math.min(n8, n6);
                        n3 = this.drawText(string, n2, n6 - n2, n3, n4, gC, styledTextBidi, controlCharRenderer);
                        n2 = n6;
                        break block18;
                    }
                    if (n7 <= n2) break block19;
                }
                if (n6 >= n8) break;
                n5 = Math.min(n7, n8) - n2;
                if (styleRange.background != null) {
                    color3 = this.setLineBackground(gC, color3, styleRange.background);
                    color4 = this.setLineForeground(gC, color4, styleRange.background);
                    if (styledTextBidi != null) {
                        styledTextBidi.fillBackground(n2, n5, this.leftMargin - n9, n4, this.lineHeight);
                    } else {
                        int n12 = this.getTextWidth(string, n, n2, n5, styleRangeArray2, n3, gC);
                        gC.fillRectangle(n3 - n9 + this.leftMargin, n4, n12, this.lineHeight);
                    }
                } else {
                    color3 = this.setLineBackground(gC, color3, color);
                }
                color4 = styleRange.foreground != null ? this.setLineForeground(gC, color4, styleRange.foreground) : this.setLineForeground(gC, color4, color2);
                this.setLineFont(gC, styleRange.fontStyle);
                n3 = this.drawText(string, n2, n5, n3, n4, gC, styledTextBidi, controlCharRenderer);
                n2 += n5;
            }
            ++n11;
        }
        if (!(styleRange != null && n2 >= n8 || n3 >= n10 && styledTextBidi == null)) {
            this.setLineBackground(gC, color3, color);
            this.setLineForeground(gC, color4, color2);
            this.setLineFont(gC, 0);
            this.drawText(string, n2, n8 - n2, n3, n4, gC, styledTextBidi, controlCharRenderer);
        }
        n11 = n2;
        n5 = n11 + n8 - n2;
        n6 = n11;
        while (n6 < n5) {
            n7 = string.indexOf(9, n6);
            if (n7 == -1 || n7 > n5) {
                n7 = n5;
            }
            if (n7 != n6) {
                String string2 = string.substring(n6, n7);
                char[] cArray = string2.toCharArray();
                int n13 = n3 - n9 + this.leftMargin;
                int n14 = n4;
                int n15 = 0;
                while (n15 < cArray.length) {
                    if (cArray[n15] == '\u3000') {
                        controlCharRenderer.drawFullWidthSpace(n13, n14, gC);
                    }
                    n13 += gC.stringExtent((String)String.valueOf((char)cArray[n15])).x;
                    ++n15;
                }
                n3 += gC.stringExtent((String)string2).x;
                if (n7 != n5 && this.tabWidth > 0) {
                    n3 = this.getTabStop(n3);
                }
                n6 = n7;
            } else if (this.tabWidth > 0 && !this.isBidi()) {
                n3 = this.getTabStop(n3);
            }
            ++n6;
        }
        controlCharRenderer.drawLineBreak(n3 - n9 + this.leftMargin, n4, gC);
    }

    private int drawText(String string, int n, int n2, int n3, int n4, GC gC, StyledTextBidi styledTextBidi, ControlCharRenderer controlCharRenderer) {
        int n5 = n + n2;
        int n6 = string.length();
        int n7 = this.getHorizontalPixel();
        if (n < 0 || n >= n6 || n + n2 > n6) {
            return n3;
        }
        int n8 = n;
        while (n8 < n5) {
            int n9 = string.indexOf(9, n8);
            if (n9 == -1 || n9 > n5) {
                n9 = n5;
            }
            if (n9 != n8) {
                if (styledTextBidi != null) {
                    styledTextBidi.drawBidiText(n8, n9 - n8, this.leftMargin - n7, n4);
                } else {
                    String string2 = string.substring(n8, n9);
                    char[] cArray = string2.toCharArray();
                    int n10 = n3 - n7 + this.leftMargin;
                    int n11 = n4;
                    int n12 = 0;
                    while (n12 < cArray.length) {
                        if (cArray[n12] == '\u3000') {
                            controlCharRenderer.drawFullWidthSpace(n10, n11, gC);
                        }
                        n10 += gC.stringExtent((String)String.valueOf((char)cArray[n12])).x;
                        ++n12;
                    }
                    gC.drawString(string2, n3 - n7 + this.leftMargin, n4, true);
                    n3 += gC.stringExtent((String)string2).x;
                    if (n9 != n5 && this.tabWidth > 0) {
                        controlCharRenderer.drawTab(n3 - n7 + this.leftMargin, n4, gC);
                        n3 = this.getTabStop(n3);
                    }
                }
                n8 = n9;
            } else if (this.tabWidth > 0 && !this.isBidi()) {
                controlCharRenderer.drawTab(n3 - n7 + this.leftMargin, n4, gC);
                n3 = this.getTabStop(n3);
            }
            ++n8;
        }
        return n3;
    }

    StyleRange[] filterLineStyles(StyleRange[] styleRangeArray) {
        if (styleRangeArray != null) {
            int n = 0;
            while (n < styleRangeArray.length && styleRangeArray[n].fontStyle == 0) {
                ++n;
            }
            if (n == styleRangeArray.length) {
                styleRangeArray = null;
            }
        }
        return styleRangeArray;
    }

    protected abstract Rectangle getClientArea();

    protected int getCurrentFontStyle() {
        return this.currentFontStyle;
    }

    protected abstract StyledTextContent getContent();

    Device getDevice() {
        return this.device;
    }

    private StyleRange[] getFontStyleRanges(StyleRange[] styleRangeArray, int n, int n2) {
        StyleRange styleRange;
        int n3 = 0;
        StyleRange[] styleRangeArray2 = null;
        if (styleRangeArray == null) {
            return null;
        }
        int n4 = 0;
        while (n4 < styleRangeArray.length) {
            styleRange = styleRangeArray[n4];
            if (styleRange.start - n < n2 && styleRange.fontStyle == 1) {
                ++n3;
            }
            ++n4;
        }
        if (n3 > 0) {
            styleRangeArray2 = new StyleRange[n3];
            n3 = 0;
            n4 = 0;
            while (n4 < styleRangeArray.length) {
                styleRange = styleRangeArray[n4];
                int n5 = styleRange.start - n;
                if (n5 < n2 && styleRange.fontStyle == 1) {
                    StyleRange styleRange2 = new StyleRange();
                    styleRange2.start = Math.max(0, n5);
                    styleRange2.length = Math.min(n5 + styleRange.length, n2) - styleRange2.start;
                    styleRangeArray2[n3] = styleRange2;
                    ++n3;
                }
                ++n4;
            }
        }
        return styleRangeArray2;
    }

    protected abstract int[] getBidiSegments(int var1, String var2);

    protected abstract GC getGC();

    protected abstract int getHorizontalPixel();

    int getLeftMargin() {
        return this.leftMargin;
    }

    int getLineEndSpaceWidth() {
        return this.lineEndSpaceWidth;
    }

    protected abstract StyledTextEvent getLineBackgroundData(int var1, String var2);

    int getLineHeight() {
        return this.lineHeight;
    }

    StyledTextEvent getLineStyleData(StyledTextEvent styledTextEvent, int n, String string) {
        int n2 = string.length();
        if (styledTextEvent.styles != null && this.getWordWrap()) {
            styledTextEvent.styles = this.getVisualLineStyleData(styledTextEvent.styles, n, n2);
        }
        if (styledTextEvent.styles == null) {
            styledTextEvent.styles = new StyleRange[0];
        } else if (this.isBidi()) {
            GC gC = this.getGC();
            if (StyledTextBidi.isLigated(gC)) {
                int[] nArray = new int[2];
                nArray[1] = n2;
                StyledTextBidi styledTextBidi = new StyledTextBidi(gC, string, nArray);
                int n3 = 0;
                while (n3 < styledTextEvent.styles.length) {
                    int n4;
                    int n5;
                    int n6;
                    StyleRange styleRange = styledTextEvent.styles[n3];
                    StyleRange styleRange2 = null;
                    int n7 = styleRange.start - n;
                    if (n7 >= 0 && (n6 = styledTextBidi.getLigatureStartOffset(n7)) != n7) {
                        styleRange = styledTextEvent.styles[n3] = (styleRange2 = (StyleRange)styleRange.clone());
                        styleRange.start -= n7 - n6;
                        styleRange.length += n7 - n6;
                    }
                    if ((n5 = (n6 = styleRange.start + styleRange.length) - n - 1) < n2 && (n4 = styledTextBidi.getLigatureEndOffset(n5)) != n5) {
                        if (styleRange2 == null) {
                            styleRange = styledTextEvent.styles[n3] = (styleRange2 = (StyleRange)styleRange.clone());
                        }
                        styleRange.length += n4 - n5;
                    }
                    ++n3;
                }
            }
            this.disposeGC(gC);
        }
        return styledTextEvent;
    }

    protected abstract StyledTextEvent getLineStyleData(int var1, String var2);

    protected abstract Point getSelection();

    protected abstract StyleRange[] mergeSelectionLineStyles(StyleRange[] var1);

    StyledTextBidi getStyledTextBidi(String string, int n, GC gC, StyleRange[] styleRangeArray) {
        StyleRange[] styleRangeArray2 = null;
        if (styleRangeArray == null) {
            StyledTextEvent styledTextEvent = this.getLineStyleData(n, string);
            if (styledTextEvent != null) {
                styleRangeArray2 = this.getFontStyleRanges(styledTextEvent.styles, n, string.length());
            }
        } else {
            styleRangeArray2 = this.getFontStyleRanges(styleRangeArray, n, string.length());
        }
        return new StyledTextBidi(gC, this.tabWidth, string, styleRangeArray2, this.boldFont, this.getBidiSegments(n, string));
    }

    protected abstract int getStyledTextWidth(String var1, int var2, StyleRange[] var3, int var4, GC var5);

    private int getTabStop(int n) {
        int n2 = this.tabWidth / this.tabLength;
        if (this.tabWidth - n % this.tabWidth < n2) {
            n += this.tabWidth;
        }
        n += this.tabWidth;
        n -= n % this.tabWidth;
        return n;
    }

    int getTextPosition(String string, int n, int n2, StyleRange[] styleRangeArray, GC gC) {
        return this.getTextWidth(string, n, 0, n2, styleRangeArray, 0, gC);
    }

    int getTextWidth(String string, int n, int n2, int n3, StyleRange[] styleRangeArray, int n4, GC gC) {
        int n5 = 0;
        int n6 = n2 + n3;
        int n7 = string.length();
        if (n2 < 0 || n2 >= n7 || n6 > n7) {
            return n5;
        }
        int n8 = n2;
        while (n8 < n6) {
            int n9 = string.indexOf(9, n8);
            if (n9 == -1 || n9 > n6) {
                n9 = n6;
            }
            if (n9 != n8) {
                String string2 = string.substring(n8, n9);
                if (styleRangeArray != null) {
                    n5 = this.getStyledTextWidth(string2, n + n8, styleRangeArray, n5, gC);
                } else {
                    this.setLineFont(gC, 0);
                    n5 += gC.stringExtent((String)string2).x;
                }
                if (n9 != n6 && this.tabWidth > 0) {
                    n5 = this.getTabStop(n4 + n5) - n4;
                }
                n8 = n9;
            } else if (this.tabWidth > 0) {
                n5 = this.getTabStop(n4 + n5) - n4;
            }
            ++n8;
        }
        return n5;
    }

    StyleRange[] getVisualLineStyleData(StyleRange[] styleRangeArray, int n, int n2) {
        int n3 = n + n2;
        int n4 = styleRangeArray.length;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4) {
            StyleRange styleRange = styleRangeArray[n6];
            if (styleRange.start < n3 && styleRange.start + styleRange.length > n) {
                ++n5;
            }
            ++n6;
        }
        if (n5 != n4) {
            StyleRange[] styleRangeArray2 = new StyleRange[n5];
            int n7 = 0;
            int n8 = 0;
            while (n7 < n4) {
                StyleRange styleRange = styleRangeArray[n7];
                if (styleRange.start < n3 && styleRange.start + styleRange.length > n) {
                    styleRangeArray2[n8++] = styleRangeArray[n7];
                }
                ++n7;
            }
            styleRangeArray = styleRangeArray2;
        }
        return styleRangeArray;
    }

    protected abstract boolean getWordWrap();

    boolean isBidi() {
        return this.isBidi;
    }

    protected abstract boolean isFullLineSelection();

    protected void setCurrentFontStyle(int n) {
        this.currentFontStyle = n;
    }

    private Color setLineBackground(GC gC, Color color, Color color2) {
        if (!color.equals(color2)) {
            gC.setBackground(color2);
        }
        return color2;
    }

    void setLineFont(GC gC, int n) {
        if (this.getCurrentFontStyle() != n) {
            this.setCurrentFontStyle(n);
            if (n == 1) {
                gC.setFont(this.boldFont);
            } else if (n == 0) {
                gC.setFont(this.regularFont);
            }
        }
    }

    private Color setLineForeground(GC gC, Color color, Color color2) {
        if (!color.equals(color2)) {
            gC.setForeground(color2);
        }
        return color2;
    }

    void setTabLength(int n) {
        GC gC = this.getGC();
        StringBuffer stringBuffer = new StringBuffer(n);
        this.tabLength = n;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(' ');
            ++n2;
        }
        this.tabWidth = gC.stringExtent((String)stringBuffer.toString()).x;
        this.disposeGC(gC);
    }
}

