/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.swt.ccs/src/jp/sourceforge/jeextension/swt/ccs/preferences/SWTCCSPreferencePage.java,v 1.2 2005/01/23 06:42:24 kohnosuke Exp $
 * $Revision: 1.2 $
 * $Date: 2005/01/23 06:42:24 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.swt.ccs.preferences;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

import jp.sourceforge.jeextension.common.plugin.DefaultPreferencePage;
import jp.sourceforge.jeextension.swt.ccs.SWTCCSPlugin;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;


/**
 * SWTStyledTextPreferencePage.
 */
public class SWTCCSPreferencePage extends DefaultPreferencePage {
    
    /**
     * Selections for Color Combo Item.
     */
    private static final String[] COLOR_ITEMS = new String[] {
        "COLOR_WHITE",
        "COLOR_BLACK",
        "COLOR_RED",
        "COLOR_DARK_RED",
        "COLOR_GREEN",
        "COLOR_DARK_GREEN",
        "COLOR_YELLOW",
        "COLOR_DARK_YELLOW",
        "COLOR_BLUE",
        "COLOR_DARK_BLUE",
        "COLOR_MAGENTA",
        "COLOR_DARK_MAGENTA",
        "COLOR_CYAN",
        "COLOR_DARK_CYAN",
        "COLOR_GRAY",
        "COLOR_DARK_GRAY",
    };
    
    /**
     * key of org.eclipse.swt.custom.StyledTextRenderer.
     */
    private static final String COLOR_ALL = "jeex.all.color";
    
    /**
     * key of org.eclipse.swt.custom.StyledTextRenderer.
     */
    private static final String COLOR_LNB = "jeex.lf.color";
    
    /**
     * key of org.eclipse.swt.custom.StyledTextRenderer.
     */
    private static final String COLOR_EOF = "jeex.eof.color";
    
    /**
     * key of org.eclipse.swt.custom.StyledTextRenderer.
     */
    private static final String COLOR_TAB = "jeex.tab.color";
    
    /**
     * key of org.eclipse.swt.custom.StyledTextRenderer.
     */
    private static final String COLOR_FWS = "jeex.fws.color";
    
    /**
     * key of org.eclipse.swt.custom.StyledTextRenderer.
     */
    private static final String ENABLE_ALL = "jeex.all.enable";
    
    /**
     * key of org.eclipse.swt.custom.StyledTextRenderer.
     */
    private static final String ENABLE_LNB = "jeex.lf.enable";
    
    /**
     * key of org.eclipse.swt.custom.StyledTextRenderer.
     */
    private static final String ENABLE_EOF = "jeex.eof.enable";
    
    /**
     * key of org.eclipse.swt.custom.StyledTextRenderer.
     */
    private static final String ENABLE_TAB = "jeex.tab.enable";
    
    /**
     * key of org.eclipse.swt.custom.StyledTextRenderer.
     */
    private static final String ENABLE_FWS = "jeex.fws.enable";
    
    /**
     * Properties keys.
     */
    public static final String[] PROPERTY_KEYS = new String[] {
        COLOR_ALL,
        COLOR_EOF,
        COLOR_FWS,
        COLOR_LNB,
        COLOR_TAB,
        ENABLE_ALL,
        ENABLE_EOF,
        ENABLE_FWS,
        ENABLE_LNB,
        ENABLE_TAB,
    };
    
    /**
     * a Button on PreferencePage.
     */
    private Button fBtnEOF;
    
    /**
     * a Button on PreferencePage.
     */
    private Button fBtnFWS;
    
    /**
     * a Button on PreferencePage.
     */
    private Button fBtnLNB;
    
    /**
     * a Button on PreferencePage.
     */
    private Button fBtnTAB;
    
    /**
     * a ComboBox on PreferencePage.
     */
    private Combo  fCmbEOF;
    
    /**
     * a ComboBox on PreferencePage.
     */
    private Combo  fCmbFWS;
    
    /**
     * a ComboBox on PreferencePage.
     */
    private Combo  fCmbLNB;
    
    /**
     * a ComboBox on PreferencePage.
     */
    private Combo  fCmbTAB;
    
    /** Properties for settings. */
    private static Properties fSetting = SWTCCSPlugin.getProperties();
    
    /**
     * Default Constructer.
     */
    public SWTCCSPreferencePage() {
        super();
        setPreferenceStore(SWTCCSPlugin.getDefault().getPreferenceStore());
        setDescription(getMessage("pref.desc"));
    }
    
    /**
     * @see org.eclipse.jface.preference.PreferencePage#createContents(org.eclipse.swt.widgets.Composite)
     */
    protected Control createContents(Composite parent) {
        
        // Container designed layout.
        Composite container = new Composite(parent, SWT.NULL);
        final GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        container.setLayout(gridLayout);
        
        //
        // LineBreak Contens.
        //
        fBtnLNB = new Button(container, SWT.CHECK);
        fBtnLNB.setText(getMessage("pref.linebreak"));
        fBtnLNB.addListener(SWT.Selection, this);
        
        final Label labelLB = new Label(container, SWT.NONE);
        labelLB.setText(getMessage("pref.color"));
        
        fCmbLNB = new Combo(container, SWT.READ_ONLY);
        fCmbLNB.setItems(COLOR_ITEMS);
        
        //
        // TAB Contens.
        //
        fBtnTAB = new Button(container, SWT.CHECK);
        fBtnTAB.setText(getMessage("pref.tab"));
        fBtnTAB.addListener(SWT.Selection, this);
        
        final Label labelTAB = new Label(container, SWT.NONE);
        labelTAB.setText(getMessage("pref.color"));
        
        fCmbTAB = new Combo(container, SWT.READ_ONLY);
        fCmbTAB.setItems(COLOR_ITEMS);
        
        //
        // EOF Contens.
        //
        fBtnEOF = new Button(container, SWT.CHECK);
        fBtnEOF.setText(getMessage("pref.eof"));
        fBtnEOF.addListener(SWT.Selection, this);
        
        final Label labelEOF = new Label(container, SWT.NONE);
        labelEOF.setText(getMessage("pref.color"));
        
        fCmbEOF = new Combo(container, SWT.READ_ONLY);
        fCmbEOF.setItems(COLOR_ITEMS);
        
        //
        // FullWidthSpace Contens.
        //
        fBtnFWS = new Button(container, SWT.CHECK);
        fBtnFWS.setText(getMessage("pref.fws"));
        fBtnFWS.addListener(SWT.Selection, this);
        
        final Label labelFWS = new Label(container, SWT.NONE);
        labelFWS.setText(getMessage("pref.color"));
        
        fCmbFWS = new Combo(container, SWT.READ_ONLY);
        fCmbFWS.setItems(COLOR_ITEMS);
        
        
        return container;
    }
    
    /**
     * Returns index of ComboBox items from Item Strings.
     * If it isn't include items, returns 14 means COLOR_GRAY.
     * @param str Item String.
     * @return index of ComboBox items.
     */
    private int getComboIndex(String str) {
        for (int i = 0; i < COLOR_ITEMS.length; i++) {
            if (COLOR_ITEMS[i].equals(str)) {
                return i;
            }
        }
        return 14; // COLOR_GRAY
    }
    
    /**
     * {@inheritDoc}
     * @see org.eclipse.swt.widgets.Listener#handleEvent(org.eclipse.swt.widgets.Event)
     */
    public void handleEvent(Event event) {
        if (event.widget == fBtnFWS) {
            fCmbFWS.setEnabled(fBtnFWS.getSelection());
        }
        if (event.widget == fBtnTAB) {
            fCmbTAB.setEnabled(fBtnTAB.getSelection());
        }
        if (event.widget == fBtnEOF) {
            fCmbEOF.setEnabled(fBtnEOF.getSelection());
        }
        if (event.widget == fBtnLNB) {
            fCmbLNB.setEnabled(fBtnLNB.getSelection());
        }
    }
    
    /**
     * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
     */
    public void init(IWorkbench workbench) {
    }
    
    /**
     * Set swt.custom.StyledTextRenderer properties to System Properties.
     */
    private void performColor() {
        
        String s1 = fCmbFWS.getItem(fCmbFWS.getSelectionIndex());
        String s2 = fCmbTAB.getItem(fCmbTAB.getSelectionIndex());
        String s3 = fCmbEOF.getItem(fCmbEOF.getSelectionIndex());
        String s4 = fCmbLNB.getItem(fCmbLNB.getSelectionIndex());
        
        if (s2.equals(s1) && s3.equals(s1) && s4.equals(s1)) {
            fSetting.setProperty(COLOR_ALL, s1);
            fSetting.remove(COLOR_FWS);
            fSetting.remove(COLOR_TAB);
            fSetting.remove(COLOR_EOF);
            fSetting.remove(COLOR_LNB);
        }
        else {
            fSetting.remove(COLOR_ALL);
            fSetting.setProperty(COLOR_FWS, s1);
            fSetting.setProperty(COLOR_TAB, s2);
            fSetting.setProperty(COLOR_EOF, s3);
            fSetting.setProperty(COLOR_LNB, s4);
        }
        
        boolean b1 = fBtnFWS.getSelection();
        boolean b2 = fBtnTAB.getSelection();
        boolean b3 = fBtnEOF.getSelection();
        boolean b4 = fBtnLNB.getSelection();
        if (!b1 && !b2 && !b3 && !b4) {
            fSetting.remove(COLOR_ALL);
            fSetting.remove(COLOR_FWS);
            fSetting.remove(COLOR_TAB);
            fSetting.remove(COLOR_EOF);
            fSetting.remove(COLOR_LNB);
        }
    }
    
    /**
     * Set swt.custom.StyledTextRenderer properties to System Properties.
     */
    private void performEnable() {
        
        boolean b1 = fBtnFWS.getSelection();
        boolean b2 = fBtnTAB.getSelection();
        boolean b3 = fBtnEOF.getSelection();
        boolean b4 = fBtnLNB.getSelection();
        
        if (b1 && b2 && b3 && b4) {
            fSetting.setProperty(ENABLE_ALL, "true");
            fSetting.remove(ENABLE_FWS);
            fSetting.remove(ENABLE_TAB);
            fSetting.remove(ENABLE_EOF);
            fSetting.remove(ENABLE_LNB);
        }
        else if (!b1 && !b2 && !b3 && !b4) {
            fSetting.remove(ENABLE_ALL);
            fSetting.remove(ENABLE_FWS);
            fSetting.remove(ENABLE_TAB);
            fSetting.remove(ENABLE_EOF);
            fSetting.remove(ENABLE_LNB);
        }
        else {
            fSetting.remove(ENABLE_ALL);
            fSetting.setProperty(ENABLE_FWS, String.valueOf(b1));
            fSetting.setProperty(ENABLE_TAB, String.valueOf(b2));
            fSetting.setProperty(ENABLE_EOF, String.valueOf(b3));
            fSetting.setProperty(ENABLE_LNB , String.valueOf(b4));
        }
    }
    
    /**
     * {@inheritDoc}
     * @see org.eclipse.jface.preference.IPreferencePage#performOk()
     */
    public boolean performOk() {
        performEnable();
        performColor();
        System.getProperties().put("jeex.swt.ccs", fSetting);
        
        // save to preference store.
        Properties setting = SWTCCSPlugin.getProperties();
        IPreferenceStore store = getPreferenceStore();
        Iterator iterator1 = setting.keySet().iterator();
        while (iterator1.hasNext()) {
            String key = (String) iterator1.next();
            String val = setting.getProperty(key);
            
            store.setValue(key, val);
        }
        
        // redraw.
        List list = (List) System.getProperties().get("jeex.swt.ccs.list");
        if (list == null) {
            list = new Vector();
            System.getProperties().put("jeex.swt.ccs.list", list);
        }
        
        // remove disposed Widget
        Object[] obj1;
        synchronized (list) {
            obj1 = list.toArray();
        }
        for (int i = 0; i < obj1.length; i++) {
            StyledText widget = (StyledText) obj1[i];
            if (widget.isDisposed()) {
                list.remove(widget);
            }
        }
        
        // redraw widget.
        Object[] obj2;
        synchronized (list) {
            obj2 = list.toArray();
        }
        for (int i = 0; i < obj2.length; i++) {
            StyledText widget = (StyledText) obj2[i];
            widget.redraw();
        }
        
        return super.performOk();
    }
    
    /**
     * {@inheritDoc}
     * @see org.eclipse.jface.dialogs.IDialogPage#setVisible(boolean)
     */
    public void setVisible(boolean visible) {
        
        // All Enable setting.
        String allEnable = fSetting.getProperty(ENABLE_ALL);
        if (allEnable != null) {
            boolean enable = Boolean.valueOf(allEnable).booleanValue();
            fBtnFWS.setSelection(enable);
            fBtnTAB.setSelection(enable);
            fBtnEOF.setSelection(enable);
            fBtnLNB.setSelection(enable);
        }
        // Each Other setting.
        String lfEnable = fSetting.getProperty(ENABLE_LNB);
        if (lfEnable != null) {
            fBtnLNB.setSelection(Boolean.valueOf(lfEnable).booleanValue());
        }
        String fwsEnable = fSetting.getProperty(ENABLE_FWS);
        if (fwsEnable != null) {
            fBtnFWS.setSelection(Boolean.valueOf(fwsEnable).booleanValue());
        }
        String tabEnable = fSetting.getProperty(ENABLE_TAB);
        if (tabEnable != null) {
            fBtnTAB.setSelection(Boolean.valueOf(tabEnable).booleanValue());
        }
        String eofEnable = fSetting.getProperty(ENABLE_EOF);
        if (eofEnable != null) {
            fBtnEOF.setSelection(Boolean.valueOf(eofEnable).booleanValue());
        }
        
        // All Color setting.
        String allColor = fSetting.getProperty(COLOR_ALL);
        if (allColor != null) {
            int i = getComboIndex(allColor);
            fCmbFWS.select(i);
            fCmbTAB.select(i);
            fCmbEOF.select(i);
            fCmbLNB.select(i);
        }
        // Each Other setting.
        String lnbColor = fSetting.getProperty(COLOR_LNB);
        fCmbLNB.select(getComboIndex(lnbColor));
        String fwsColor = fSetting.getProperty(COLOR_FWS);
        fCmbFWS.select(getComboIndex(fwsColor));
        String tabColor = fSetting.getProperty(COLOR_TAB);
        fCmbTAB.select(getComboIndex(tabColor));
        String eofColor = fSetting.getProperty(COLOR_EOF);
        fCmbEOF.select(getComboIndex(eofColor));
        
        fCmbFWS.setEnabled(fBtnFWS.getSelection());
        fCmbTAB.setEnabled(fBtnTAB.getSelection());
        fCmbEOF.setEnabled(fBtnEOF.getSelection());
        fCmbLNB.setEnabled(fBtnLNB.getSelection());
        
        super.setVisible(visible);
    }
}
