/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.core;

import jp.sourceforge.jeextension.styleeditor.core.EditorConfiguration;
import jp.sourceforge.jeextension.styleeditor.core.EditorTools;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;

class DocumentProvider
extends FileDocumentProvider {
    private EditorTools fEditorTools;

    DocumentProvider(EditorConfiguration conf) {
        this.fEditorTools = new EditorTools(conf);
    }

    private IDocumentPartitioner createDocumentPartitioner(String ext) {
        RuleBasedPartitionScanner scanner = this.fEditorTools.createPartitionScanner(ext);
        String[] contentTypes = this.fEditorTools.getContentTypesExcludeDefault(ext);
        return new DefaultPartitioner((IPartitionTokenScanner)scanner, contentTypes);
    }

    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document = super.createDocument(element);
        if (document != null) {
            IDocumentPartitioner partitioner;
            if (element instanceof IFileEditorInput) {
                IFileEditorInput input = (IFileEditorInput)element;
                String ext = input.getFile().getFileExtension();
                partitioner = this.createDocumentPartitioner(ext);
            } else {
                partitioner = this.createDocumentPartitioner("*");
            }
            document.setDocumentPartitioner(partitioner);
            partitioner.connect(document);
        }
        return document;
    }
}

