/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/core/DocumentProvider.java,v 1.1 2005/01/29 03:24:19 kohnosuke Exp $
 * $Revision: 1.1 $
 * $Date: 2005/01/29 03:24:19 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.core;


import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;

/**
 * DocumentProvider is defined rules provider.
 */
class DocumentProvider extends FileDocumentProvider {

    /** Defined Style Editor Tool. */
    private EditorTools fEditorTools;

    /**
     * Iniciate Object using Configuration object.
     * @param conf Configuration.
     */
    DocumentProvider(EditorConfiguration conf) {
        this.fEditorTools = new EditorTools(conf);
    }

    /**
     * Create a IDocumentPartitioner.
     * @param ext   extension name. (ex. java, means *.java)
     * @return IDocumentPartitioner instance.
     */
    private IDocumentPartitioner createDocumentPartitioner(String ext) {
        RuleBasedPartitionScanner scanner =
                fEditorTools.createPartitionScanner(ext);
        String[] contentTypes =
                fEditorTools.getContentTypesExcludeDefault(ext);
        
        return new DefaultPartitioner(scanner, contentTypes);
    }

    /**
     * {@inheritDoc}
     * @see org.eclipse.ui.texteditor.AbstractDocumentProvider#createDocument(java.lang.Object)
     */
    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document = super.createDocument(element);
        if (document != null) {
            IDocumentPartitioner partitioner;
            if (element instanceof IFileEditorInput) {
                // get resource's extension on current editor .
                IFileEditorInput input = (IFileEditorInput) element;
                String ext = input.getFile().getFileExtension();
                
                partitioner = createDocumentPartitioner(ext);
            } else {
                partitioner = createDocumentPartitioner("*");
            }
            document.setDocumentPartitioner(partitioner);
            partitioner.connect(document);
        }
        return document;
    }
}