/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: $
 * $Revision: $
 * $Date: $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.entry;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;

/**
 * FontEntry
 */
public class FontEntry {

    /** Font name. */
    private String fName;

    /** Font size. */
    private int fSize;

    /**
     * Initiate this entry object.
     * @param name  name of Font.
     * @param size  size of Font.
     */
    public FontEntry(String name, String size) {
        super();
        fName = name;
        fSize = Integer.parseInt(size);
    }

    /**
     * Return fontname.
     * @return  fontname.
     */
    public String getName() {
        return fName;
    }

    /**
     * Return fontsize.
     * @return  fontsize.
     */
    public int getSize() {
        return fSize;
    }
    
    /**
     * Set font name.
     * @param name fontname.
     */
    public void setName(String name) {
        fName = name;
    }
    
    /**
     * Set font size.
     * @param size  fontsize.
     */
    public void setSize(int size) {
        fSize = size;
    }

    /**
     * Return Font object.
     * @return  Font object.
     */
    public Font getFont() {
        return new Font(null, fName, fSize, SWT.NONE);
    }
}
