/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/entry/IEntry.java,v 1.1 2005/01/29 03:24:35 kohnosuke Exp $
 * $Revision: 1.1 $
 * $Date: 2005/01/29 03:24:35 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.entry;

import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.styleeditor.text.IExtRule;

import org.eclipse.swt.graphics.RGB;

/**
 * IEntry
 */
public interface IEntry {
    
    /**
     * Create XMLNode instance of current state.
     * @return XMLNode instance.
     */
    XMLNode createNode();
    
    /**
     * Return entry name of type.
     * @return multiLine | singleLine | endOfLine | keyword
     */
    String getName();
    /**
     * Returns defined RGB for text attributes.
     * @return RGB.
     */
    RGB getRGB();
    
    /**
     * Return IExtRule.
     * @return IExtRule.
     */
    IExtRule getRule();
    
    /**
     * Set RGB for text attributes.
     * @param rgb RGB.
     */
    void setRGB(RGB rgb);
    
    /**
     * Set IExtRule.
     * @param rule  IExtRule
     */
    void setRule(IExtRule rule);
}
