/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/preferences/AddPartitionDialog.java,v 1.2 2005/01/30 06:02:40 kohnosuke Exp $
 * $Revision: 1.2 $
 * $Date: 2005/01/30 06:02:40 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.preferences;

import jp.sourceforge.jeextension.common.plugin.DefaultDialog;
import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.styleeditor.core.EditorTools;
import jp.sourceforge.jeextension.styleeditor.entry.IPartitionEntry;
import jp.sourceforge.jeextension.styleeditor.entry.PartitionEntry;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Composite;

/**
 * AddPartitionDialog
 */
class AddPartitionDialog extends DefaultDialog {
    
    /** ColorSelector button. */
    private ColorSelector fColorSel;

    /** 'End' Label. */
    private Label fLabelEnd;

    /** 'Keyword' Label. */
    private Label fLabelKwd;

    /** 'Start' Label. */
    private Label fLabelStr;
    
    /** return values reference when dialog was disposed. */
    private IPartitionEntry[] fStyleContainer;
    
    /** dialog values container. */
    private IPartitionEntry fStyleEntry;
    
    /** End's Text. */
    private Text fTextEnd;
    
    /** Keyword's Text. */
    private Text fTextNme;
    
    /** Start's Text. */
    private Text fTextStr;
    
    /** Base's Check Button. */
    private Button fCheckBase;
    
    /** current editting extension. */
    private String fExtension;
    
    /**
     * Initiate AddPartitionDialog Window.
     * @param shell     shell using on parent window
     * @param container dialog values container.
     * @param ext   extension name. (ex. java, means *.java)
     */
    AddPartitionDialog(Shell shell, IPartitionEntry[] container, String ext) {
        super(shell);
        this.fStyleEntry = container[0];
        this.fStyleContainer = container;
        this.fExtension = ext;
    }
    
    /**
     * @see org.eclipse.swt.widgets.Listener#handleEvent(org.eclipse.swt.widgets.Event)
     */
    public void handleEvent(Event event) {
        if (event.widget == fCheckBase) {
            if (fCheckBase.getSelection()) {
                fTextStr.setText("");
                fTextEnd.setText("");
                fTextNme.setText(IDocument.DEFAULT_CONTENT_TYPE);
                
                fTextStr.setEnabled(false);
                fTextEnd.setEnabled(false);
                fTextNme.setEnabled(false);
            }
            else {
                fTextStr.setEnabled(true);
                fTextEnd.setEnabled(true);
                fTextNme.setEnabled(true);
            }
        }
    }

    /**
     * {@inheritDoc}
     * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
     */
    protected Control createDialogArea(Composite parent) {
        
        final Composite composite = (Composite) super.createDialogArea(parent);
        final GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout(gridLayout);
        
        fCheckBase = new Button(composite, SWT.CHECK);
        fCheckBase.setText(getMessage("pref.partition.dlg.base"));
        fCheckBase.setSelection(false);
        fCheckBase.addListener(SWT.Selection, this);
        final GridData gridData = new GridData(GridData.FILL_HORIZONTAL);
        gridData.horizontalSpan = 2;
        fCheckBase.setLayoutData(gridData);
        
        fLabelStr = new Label(composite, SWT.NONE);
        fLabelStr.setText(getMessage("pref.partition.dlg.start"));
        
        fTextStr = new Text(composite, SWT.BORDER);
        fTextStr.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        
        fLabelEnd = new Label(composite, SWT.NONE);
        fLabelEnd.setText(getMessage("pref.partition.dlg.end"));
        
        fTextEnd = new Text(composite, SWT.BORDER);
        fTextEnd.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        
        fLabelKwd = new Label(composite, SWT.NONE);
        fLabelKwd.setText(getMessage("pref.partition.dlg.name"));
        
        fTextNme = new Text(composite, SWT.BORDER);
        fTextNme.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        
        final Label cLabelClr = new Label(composite, SWT.NONE);
        cLabelClr.setText(getMessage("pref.partition.dlg.color"));
        
        fColorSel = new ColorSelector(composite);
        fColorSel.setColorValue(new RGB(0, 0, 0));
        
        if (fStyleEntry != null) {
            PartitionEntry pe = (PartitionEntry) fStyleEntry;
            fTextStr.setText(pe.getStart());
            fTextEnd.setText(pe.getEnd());
            fTextNme.setText(pe.getName());
            fColorSel.setColorValue(fStyleEntry.getRGB());
        }
        
        return composite;
    }
    
    /**
     * {@inheritDoc}
     * @see org.eclipse.jface.dialogs.Dialog#okPressed()
     */
    protected void okPressed() {
        RGB rgb = fColorSel.getColorValue();
        XMLNode node = new XMLNode("partition");
        node.setAttribute("name" , fTextNme.getText());
        node.setAttribute("red"  , String.valueOf(rgb.red));
        node.setAttribute("green", String.valueOf(rgb.green));
        node.setAttribute("blue" , String.valueOf(rgb.blue));
        node.setAttribute("start", fTextStr.getText());
        node.setAttribute("end"  , fTextEnd.getText());
        
        if (fStyleEntry == null) {
            fStyleEntry = new PartitionEntry(node, fExtension);
        }
        else {
            EditorTools.changePartitionEntry(fStyleEntry, node, fExtension);
        }
        this.fStyleContainer[0] = fStyleEntry;
        
        super.okPressed();
    }
}
