/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.common.xml;

import java.util.LinkedHashMap;
import java.util.Map;
import jp.sourceforge.jeextension.common.xml.XMLNodeList;

public final class XMLNode {
    private Map attributes = new LinkedHashMap();
    private XMLNodeList childNodeList = new XMLNodeList();
    private String nodeName;
    private String nodeValue;
    private XMLNode parentNode;

    public XMLNode(String string) {
        this(string, "");
    }

    public XMLNode(String string, String string2) {
        this.nodeName = string;
        this.nodeValue = string2;
    }

    public void addChild(XMLNode xMLNode) {
        if (!this.nodeValue.equals("")) {
            throw new IllegalArgumentException("can't add child node that having value[" + this.nodeValue + "].");
        }
        this.childNodeList.add(xMLNode);
        xMLNode.setParent(this);
    }

    public String getAttribute(String string) {
        return (String)this.attributes.get(string);
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public XMLNodeList getChildNodes() {
        return this.childNodeList;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getNodeValue() {
        return this.nodeValue;
    }

    public XMLNode getParentNode() {
        return this.parentNode;
    }

    public boolean hasAttribute(String string) {
        return this.attributes.containsKey(string);
    }

    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    public boolean hasChildNodes() {
        return !this.childNodeList.isEmpty();
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    public void removeChild(XMLNode xMLNode) {
        this.childNodeList.remove(xMLNode);
    }

    public void setAttribute(String string, String string2) {
        this.attributes.put(string, string2);
    }

    public void setNodeValue(String string) {
        this.nodeValue = string;
    }

    private void setParent(XMLNode xMLNode) {
        this.parentNode = xMLNode;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[nodeName=");
        stringBuffer.append(this.nodeName);
        stringBuffer.append(", nodeValue=");
        stringBuffer.append(this.nodeValue);
        stringBuffer.append(", chileNodes=");
        stringBuffer.append(this.childNodeList.size());
        if (this.childNodeList.size() != 0) {
            stringBuffer.append("[");
            stringBuffer.append(this.childNodeList.toString());
            stringBuffer.append("]");
        }
        stringBuffer.append(", attributes=");
        stringBuffer.append(this.attributes.size());
        if (this.attributes.size() != 0) {
            stringBuffer.append("[");
            stringBuffer.append(this.attributes.toString());
            stringBuffer.append("]");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object.getClass() != this.getClass()) {
            return false;
        }
        XMLNode xMLNode = (XMLNode)object;
        if (!xMLNode.getNodeName().equals(this.nodeName)) {
            return false;
        }
        if (!xMLNode.getNodeValue().equals(this.nodeValue)) {
            return false;
        }
        if (!((Object)xMLNode.getAttributes()).equals(this.attributes)) {
            return false;
        }
        XMLNodeList xMLNodeList = xMLNode.getChildNodes();
        XMLNodeList xMLNodeList2 = this.getChildNodes();
        if (xMLNodeList.size() != xMLNodeList2.size()) {
            return false;
        }
        for (int i = 0; i < xMLNodeList.size(); ++i) {
            XMLNode xMLNode2 = (XMLNode)xMLNodeList.get(i);
            XMLNode xMLNode3 = (XMLNode)xMLNodeList2.get(i);
            boolean bl = xMLNode3.equals(xMLNode2);
            if (bl) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

