/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.common.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.sourceforge.jeextension.common.xml.XMLException;
import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.common.xml.XMLNodeBuilder;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public final class XMLReader {
    private boolean parseValidation = false;
    private String fileEncoding;

    public XMLReader() {
        this(System.getProperty("file.encoding"));
    }

    public XMLReader(String string) {
        this.fileEncoding = string;
    }

    public XMLNode readAsXMLNode(File file) throws XMLException {
        Document document = this.readAsDocument(file);
        XMLNodeBuilder xMLNodeBuilder = new XMLNodeBuilder(document);
        return xMLNodeBuilder.build();
    }

    public XMLNode readAsXMLNode(InputStream inputStream) throws XMLException {
        Document document = this.readAsDocument(inputStream);
        XMLNodeBuilder xMLNodeBuilder = new XMLNodeBuilder(document);
        return xMLNodeBuilder.build();
    }

    public Document readAsDocument(InputStream inputStream) throws XMLException {
        try {
            InputSource inputSource = new InputSource(new InputStreamReader(inputStream, this.fileEncoding));
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(this.parseValidation);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            return document;
        }
        catch (Exception exception) {
            throw new XMLException("Can't read xml file.", exception);
        }
    }

    public Document readAsDocument(File file) throws XMLException {
        try {
            if (file.isDirectory()) {
                throw new XMLException(file + " is directory. must be a file.");
            }
            return this.readAsDocument(new FileInputStream(file));
        }
        catch (Exception exception) {
            throw new XMLException(file.getPath() + " can't read.", exception);
        }
    }

    public void setValidation(boolean bl) {
        this.parseValidation = bl;
    }
}

