/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.trax;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.dom.DOMBuilder;
import org.apache.xalan.xsltc.dom.SAXImpl;
import org.apache.xalan.xsltc.dom.XSLTCDTMManager;
import org.apache.xml.dtm.DTM;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class XSLTCSource
implements Source {
    private String _systemId = null;
    private DOM _dom = null;
    private static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";

    public XSLTCSource(int size) {
        XSLTCDTMManager dtmManager = XSLTCDTMManager.newInstance();
        int dtmPos = dtmManager.getFirstFreeDTMID();
        int documentID = dtmPos << 16;
        this._dom = new SAXImpl(dtmManager, (Source)this, documentID, null, null, false, size, true);
        dtmManager.addDTM((DTM)((Object)this._dom), dtmPos);
    }

    public XSLTCSource() {
        XSLTCDTMManager dtmManager = XSLTCDTMManager.newInstance();
        int dtmPos = dtmManager.getFirstFreeDTMID();
        int documentID = dtmPos << 16;
        this._dom = new SAXImpl(dtmManager, this, documentID, null, null, false, true);
        dtmManager.addDTM((DTM)((Object)this._dom), dtmPos);
    }

    public void setSystemId(String systemId) {
        this._systemId = new File(systemId).exists() ? "file:" + systemId : systemId;
        ((SAXImpl)this._dom).setDocumentURI(this._systemId);
    }

    public String getSystemId() {
        return this._systemId;
    }

    public void build(XMLReader reader, String systemId) throws SAXException {
        try {
            if (systemId == null && this._systemId == null) {
                ErrorMsg err = new ErrorMsg("XSLTC_SOURCE_ERR");
                throw new SAXException(err.toString());
            }
            if (systemId == null) {
                systemId = this._systemId;
            }
            this.setSystemId(systemId);
            InputSource input = new InputSource(systemId);
            DOMBuilder builder = ((SAXImpl)this._dom).getBuilder();
            reader.setContentHandler(builder);
            reader.setDTDHandler(builder);
            try {
                reader.setProperty(LEXICAL_HANDLER_PROPERTY, builder);
            }
            catch (SAXException e) {
                // empty catch block
            }
            reader.parse(input);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void build(String systemId) throws SAXException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            this.build(reader, systemId);
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    public void build(XMLReader reader) throws SAXException {
        this.build(reader, this._systemId);
    }

    public void build() throws SAXException {
        this.build(this._systemId);
    }

    protected DOM getDOM() {
        return this._dom;
    }
}

