/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.entry;

import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.styleeditor.core.EditorTools;
import jp.sourceforge.jeextension.styleeditor.entry.DependsEntryList;
import jp.sourceforge.jeextension.styleeditor.entry.IPartitionEntry;
import jp.sourceforge.jeextension.styleeditor.text.IExtRule;
import org.eclipse.swt.graphics.RGB;

public class PartitionEntry
implements IPartitionEntry {
    private String fEnd = "";
    private String fName = "";
    private RGB fRGB = new RGB(0, 0, 0);
    private IExtRule fRule;
    private String fStart = "";
    private DependsEntryList fDepends = new DependsEntryList();

    public PartitionEntry() {
    }

    public PartitionEntry(XMLNode node, String ext) {
        this.fName = node.getAttribute("name");
        this.fStart = node.getAttribute("start");
        this.fEnd = node.getAttribute("end");
        this.fRGB.red = Integer.parseInt(node.getAttribute("red"));
        this.fRGB.green = Integer.parseInt(node.getAttribute("green"));
        this.fRGB.blue = Integer.parseInt(node.getAttribute("blue"));
        if (this.fName.equals("__dftl_partition_content_type")) {
            this.fName = "__dftl_partition_content_type";
            return;
        }
        this.fRule = EditorTools.createExtRule(node, ext);
    }

    public XMLNode createNode() {
        XMLNode xmlNode = new XMLNode("partition");
        xmlNode.setAttribute("name", this.fName);
        xmlNode.setAttribute("red", String.valueOf(this.fRGB.red));
        xmlNode.setAttribute("green", String.valueOf(this.fRGB.green));
        xmlNode.setAttribute("blue", String.valueOf(this.fRGB.blue));
        xmlNode.setAttribute("start", this.getStart());
        xmlNode.setAttribute("end", this.getEnd());
        return xmlNode;
    }

    public String getEnd() {
        return this.fEnd;
    }

    public String getName() {
        return this.fName;
    }

    public RGB getRGB() {
        return this.fRGB;
    }

    public IExtRule getRule() {
        return this.fRule;
    }

    public String getStart() {
        return this.fStart;
    }

    public DependsEntryList getDependsEntryList() {
        return this.fDepends;
    }

    public void setEnd(String string) {
        this.fEnd = string;
    }

    public void setName(String string) {
        this.fName = string;
    }

    public void setRGB(RGB newRgb) {
        this.fRGB = newRgb;
    }

    public void setRule(IExtRule rule) {
        this.fRule = rule;
    }

    public void setStart(String string) {
        this.fStart = string;
    }
}

