/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/entry/IPartitionEntry.java,v 1.1 2005/01/29 03:24:35 kohnosuke Exp $
 * $Revision: 1.1 $
 * $Date: 2005/01/29 03:24:35 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.entry;

/**
 * IPartitionEntry
 */
public interface IPartitionEntry extends IEntry {
    
    /**
     * Returns Partition end keyword.
     * @return end keyword.
     */
    String getEnd();
    
    /**
     * Returns Partition start keyword.
     * @return start keyword.
     */
    String getStart();
    
    /**
     * Returns list includes IDependsEntry depends this partition.
     * @return DependsEntryList
     */
    DependsEntryList getDependsEntryList();
    
    /**
     * Set partition end keyword.
     * @param end end keyword.
     */
    void setEnd(String end);
    
    /**
     * Set partition entry name.
     * @param name name of partition.
     */
    void setName(String name);
    
    /**
     * Set Partition start keyword.
     * @param start start keyword.
     */
    void setStart(String start);
}
