/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/preferences/AddExtensionDialog.java,v 1.2 2005/07/01 09:28:07 kohnosuke Exp $
 * $Revision: 1.2 $
 * $Date: 2005/07/01 09:28:07 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.preferences;

import java.util.Map;

import jp.sourceforge.jeextension.common.plugin.DefaultDialog;
import jp.sourceforge.jeextension.styleeditor.core.EditorTools;
import jp.sourceforge.jeextension.styleeditor.entry.FontEntry;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Composite;

/**
 * AddExtensionDialog
 */
class AddExtensionDialog extends DefaultDialog implements SelectionListener {
    
    /** 'Extension' Label. */
    private Label fLabelExt;
    
    /** return values reference when dialog was disposed. */
    private String[] fExtContainer;
    
    /** Extension's Text. */
    private Text fTextExt;
    
    /** Font Button. */
    private Button fButtonFont;
    
    /** Font Label. */
    private Label fLabelFont;
    
    /** current editting extension. */
    private String fExtension;
    
    /** current shell. */
    private Shell fShell;
    
    /** current fontData. */
    private FontData fFontData;
    
    /**
     * Initiate AddExtensionDialog Window.
     * @param shell     shell using on parent window
     * @param container dialog values container.
     */
    AddExtensionDialog(Shell shell, String[] container) {
        super(shell);
        this.fShell = shell;
        this.fExtension = container[0];
        this.fExtContainer = container;
        
        Font font = EditorTools.getFont(fExtension);
        fFontData = font.getFontData()[0];
    }
    
    /**
     * {@inheritDoc}
     * @see org.eclipse.swt.widgets.Listener#handleEvent(org.eclipse.swt.widgets.Event)
     */
    public void handleEvent(Event event) {
    }

    /**
     * {@inheritDoc}
     * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
     */
    protected Control createDialogArea(Composite parent) {
        
        final Composite composite = (Composite) super.createDialogArea(parent);
        final GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout(gridLayout);
        
        fLabelExt = new Label(composite, SWT.NONE);
        fLabelExt.setText(getMessage("pref.extension.dlg.label"));
        
        fTextExt = new Text(composite, SWT.BORDER);
        fTextExt.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        
        if (fExtension != null) {
            fTextExt.setText(fExtension);
        }
        
        fLabelFont = new Label(composite, SWT.NONE);
        fLabelFont.setText(fFontData.getName() + ", " + fFontData.getHeight());
        final GridData gridData1 = new GridData();
        gridData1.horizontalSpan = 2;
        fLabelFont.setLayoutData(gridData1);
        
        fButtonFont = new Button(composite, SWT.NONE);
        fButtonFont.setText(getMessage("pref.extension.dlg.font"));
        fButtonFont.addSelectionListener(this);
        
        return composite;
    }
    
    /**
     * {@inheritDoc}
     * @see org.eclipse.jface.dialogs.Dialog#okPressed()
     */
    protected void okPressed() {
        
        String newExt = fTextExt.getText();
        
        Map map = EditorTools.getPartitionEntryMap();
        Object obj = map.get(newExt);
        if (obj == null && newExt.equals("") == false) {
            // Add
            EditorTools.getPartitionEntryList(newExt, true);
            // Modify
            Object old = map.get(fExtContainer[0]);
            if (old != null) {
                // remove old entry.
                map.remove(fExtContainer[0]);
                // add new entry.
                map.put(newExt, old);
            }
        }
        Map fontEntryMap = EditorTools.getFontEntryMap();
        FontEntry fontEntry = (FontEntry) fontEntryMap.get(fExtension);
        if (fontEntry != null) {
            fontEntry.setName(fFontData.getName());
            fontEntry.setSize(fFontData.getHeight());
        }
        else {
            fontEntry = new FontEntry(fFontData.getName(),
                    String.valueOf(fFontData.getHeight()));
            fontEntryMap.put(fExtension, fontEntry);
        }
        
        fExtContainer[0] = newExt;
        
        super.okPressed();
    }
    
    /**
     * {@inheritDoc}
     * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
     */
    public void widgetSelected(SelectionEvent ev) {
        if (ev.widget == fButtonFont) {
            FontDialog d = new FontDialog(fShell);
            d.setFontList(new FontData[] {fFontData});
            FontData fontData = d.open();
            if (fontData != null) {
                fFontData = fontData;
                fLabelFont.setText(
                    fFontData.getName() + ", " + fFontData.getHeight());
            }
        }
    }
    
    /**
     * {@inheritDoc}
     * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
     */
    public void widgetDefaultSelected(SelectionEvent ev) {

    }

}
