/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.styleeditor.StyleEditorPlugin;
import jp.sourceforge.jeextension.styleeditor.core.ColorManager;
import jp.sourceforge.jeextension.styleeditor.core.EditorConfiguration;
import jp.sourceforge.jeextension.styleeditor.core.WordDetector;
import jp.sourceforge.jeextension.styleeditor.entry.DefinedStyleEntry;
import jp.sourceforge.jeextension.styleeditor.entry.DependsEntry;
import jp.sourceforge.jeextension.styleeditor.entry.DependsEntryList;
import jp.sourceforge.jeextension.styleeditor.entry.FontEntry;
import jp.sourceforge.jeextension.styleeditor.entry.IDependsEntry;
import jp.sourceforge.jeextension.styleeditor.entry.IEntry;
import jp.sourceforge.jeextension.styleeditor.entry.IPartitionEntry;
import jp.sourceforge.jeextension.styleeditor.entry.PartitionEntry;
import jp.sourceforge.jeextension.styleeditor.entry.PartitionEntryList;
import jp.sourceforge.jeextension.styleeditor.text.ExtEndOfLineRule;
import jp.sourceforge.jeextension.styleeditor.text.ExtMultiLineRule;
import jp.sourceforge.jeextension.styleeditor.text.ExtSingleLineRule;
import jp.sourceforge.jeextension.styleeditor.text.ExtTextAttribute;
import jp.sourceforge.jeextension.styleeditor.text.ExtWordRule;
import jp.sourceforge.jeextension.styleeditor.text.IColorActivator;
import jp.sourceforge.jeextension.styleeditor.text.IExtRule;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;

public class EditorTools {
    private ColorManager fColorManger;
    private IToken fDefaultToken;

    public static void changeDependsEntry(IDependsEntry entry, XMLNode node, String ext) {
        DependsEntry newEntry = new DependsEntry(node, ext);
        entry.setDepends(newEntry.getDepends());
        entry.setRGB(newEntry.getRGB());
        entry.setRule(newEntry.getRule());
        entry.setWords(newEntry.getWords());
    }

    public static void changePartitionEntry(IPartitionEntry entry, XMLNode node, String ext) {
        PartitionEntry newEntry = new PartitionEntry(node, ext);
        entry.setRGB(newEntry.getRGB());
        entry.setRule(newEntry.getRule());
        entry.setStart(newEntry.getStart());
        entry.setEnd(newEntry.getEnd());
        entry.setName(newEntry.getName());
    }

    public static IExtRule createExtRule(XMLNode node, String ext) {
        Token token;
        Token token2;
        String end;
        String start;
        IExtRule rule = null;
        String nodeName = node.getNodeName();
        RGB rgb = new RGB(0, 0, 0);
        rgb.red = Integer.parseInt(node.getAttribute("red"));
        rgb.green = Integer.parseInt(node.getAttribute("green"));
        rgb.blue = Integer.parseInt(node.getAttribute("blue"));
        if (nodeName.equals("partition")) {
            start = node.getAttribute("start");
            end = node.getAttribute("end");
            token2 = new Token((Object)node.getAttribute("name"));
            rule = new ExtMultiLineRule(start, end, (IToken)token2);
        }
        if (nodeName.equals("multiLine")) {
            start = node.getAttribute("start");
            end = node.getAttribute("end");
            token2 = new Token((Object)new ExtTextAttribute(rgb));
            rule = new ExtMultiLineRule(start, end, (IToken)token2);
        }
        if (nodeName.equals("singleLine")) {
            token = new Token((Object)new ExtTextAttribute(rgb));
            String start2 = node.getAttribute("start");
            String end2 = node.getAttribute("end");
            rule = new ExtSingleLineRule(start2, end2, (IToken)token);
        }
        if (nodeName.equals("endOfLine")) {
            token = new Token((Object)new ExtTextAttribute(rgb));
            rule = new ExtEndOfLineRule(node.getAttribute("start"), (IToken)token);
        }
        if (nodeName.equals("keyword")) {
            String partName = node.getParentNode().getAttribute("name");
            IPartitionEntry depends = EditorTools.getPartitionEntry(partName, ext, false);
            Token defaultToken = new Token((Object)new ExtTextAttribute(depends.getRGB()));
            Token token3 = new Token((Object)new ExtTextAttribute(rgb));
            ExtWordRule wRule = new ExtWordRule(new WordDetector(), (IToken)defaultToken);
            String word = node.getAttribute("word");
            String csensitive = node.getAttribute("case");
            if (csensitive == null) {
                csensitive = "true";
            }
            wRule.addWord(word, (IToken)token3, csensitive);
            rule = wRule;
        }
        return rule;
    }

    public static Map getPartitionEntryMap() {
        DefinedStyleEntry styleEntry = StyleEditorPlugin.getDefinedStyleEntry();
        return styleEntry.getPartitionEntryMap();
    }

    public static Map getFontEntryMap() {
        DefinedStyleEntry styleEntry = StyleEditorPlugin.getDefinedStyleEntry();
        return styleEntry.getFontEntryMap();
    }

    public static Font getFont(String ext) {
        Map fontEntryMap = EditorTools.getFontEntryMap();
        FontEntry fontEntry = (FontEntry)fontEntryMap.get(ext);
        if (fontEntry != null) {
            return fontEntry.getFont();
        }
        fontEntry = (FontEntry)fontEntryMap.get("*");
        if (fontEntry != null) {
            return fontEntry.getFont();
        }
        return JFaceResources.getTextFont();
    }

    public static IPartitionEntry getPartitionEntry(String partName, String ext, boolean create) {
        DefinedStyleEntry styleEntry = StyleEditorPlugin.getDefinedStyleEntry();
        return styleEntry.getPartitionEntry(partName, ext, create);
    }

    public static PartitionEntryList getPartitionEntryList(String ext, boolean create) {
        DefinedStyleEntry styleEntry = StyleEditorPlugin.getDefinedStyleEntry();
        return styleEntry.getPartitionEntryList(ext, create);
    }

    public EditorTools(EditorConfiguration conf) {
        this.fColorManger = conf.getColorManager();
        TextAttribute attr = new TextAttribute(this.fColorManger.getColor(new RGB(0, 0, 0)));
        this.fDefaultToken = new Token((Object)attr);
    }

    public RuleBasedPartitionScanner createPartitionScanner(String ext) {
        RuleBasedPartitionScanner scanner = new RuleBasedPartitionScanner();
        scanner.setPredicateRules(this.createPredicateRule(ext));
        return scanner;
    }

    public RuleBasedScanner createScanner(String partitionName, String ext) {
        RuleBasedScanner scanner = new RuleBasedScanner();
        scanner.setRules(this.createRules(partitionName, ext));
        return scanner;
    }

    public String[] getContentTypes(String ext) {
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("__dftl_partition_content_type");
        return this.createContentTypes(typeList, ext);
    }

    public String[] getContentTypesExcludeDefault(String ext) {
        return this.createContentTypes(new ArrayList(), ext);
    }

    public IToken getDefaultToken() {
        return this.fDefaultToken;
    }

    public IToken getDefaultToken(IPartitionEntry entry) {
        TextAttribute attr = new TextAttribute(this.fColorManger.getColor(entry.getRGB()));
        Token token = new Token((Object)attr);
        return token;
    }

    private void activateColor(List ruleList) {
        int i = 0;
        while (i < ruleList.size()) {
            IColorActivator rule = (IColorActivator)ruleList.get(i);
            rule.activateColor(this.fColorManger);
            ++i;
        }
    }

    private void appendRuleList(IEntry entry, List ruleList) {
        IExtRule rule = null;
        if (entry.getName().equals("keyword")) {
            int i = 0;
            while (i < ruleList.size()) {
                Object obj = ruleList.get(i);
                if (obj instanceof WordRule) {
                    rule = (WordRule)obj;
                }
                ++i;
            }
            if (rule != null) {
                ExtWordRule wRule = (ExtWordRule)entry.getRule();
                ((ExtWordRule)rule).addWordRuleMap(wRule.getWordRuleMap());
                return;
            }
            rule = entry.getRule();
            ExtWordRule wRule = (ExtWordRule)entry.getRule();
            HashMap currentMap = new HashMap(wRule.getWordRuleMap());
            wRule.getWordRuleMap().clear();
            wRule.getWordRuleMap().putAll(currentMap);
        }
        if (entry.getName().equals("multiLine")) {
            rule = entry.getRule();
        }
        if (entry.getName().equals("endOfLine")) {
            rule = entry.getRule();
        }
        if (entry.getName().equals("singleLine")) {
            rule = entry.getRule();
        }
        if (entry instanceof IPartitionEntry) {
            if (entry.getName().equals("__dftl_partition_content_type")) {
                return;
            }
            rule = entry.getRule();
        }
        ruleList.add(rule);
    }

    private String[] createContentTypes(List typeList, String ext) {
        PartitionEntryList entryList = EditorTools.getPartitionEntryList(ext, false);
        int i = 0;
        while (i < entryList.size()) {
            IPartitionEntry entry = entryList.getPartitionEntry(i);
            typeList.add(entry.getName());
            ++i;
        }
        String[] types = new String[typeList.size()];
        return typeList.toArray(types);
    }

    private IPredicateRule[] createPredicateRule(String ext) {
        PartitionEntryList entryList = EditorTools.getPartitionEntryList(ext, false);
        ArrayList ruleList = new ArrayList();
        int i = 0;
        while (i < entryList.size()) {
            IPartitionEntry entry = entryList.getPartitionEntry(i);
            this.appendRuleList(entry, ruleList);
            ++i;
        }
        this.activateColor(ruleList);
        IPredicateRule[] rules = new IPredicateRule[ruleList.size()];
        return ruleList.toArray(rules);
    }

    private IRule[] createRules(String partName, String ext) {
        IPartitionEntry partList = EditorTools.getPartitionEntry(partName, ext, false);
        DependsEntryList entryList = partList.getDependsEntryList();
        ArrayList ruleList = new ArrayList();
        int i = 0;
        while (i < entryList.size()) {
            IDependsEntry entry = entryList.getDependsEntry(i);
            String partition = entry.getDepends().getName();
            if (partition.equals(partName)) {
                this.appendRuleList(entry, ruleList);
            }
            ++i;
        }
        this.activateColor(ruleList);
        IRule[] rules = new IRule[ruleList.size()];
        return ruleList.toArray(rules);
    }
}

