/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.preferences;

import java.util.Iterator;
import java.util.Map;
import jp.sourceforge.jeextension.common.plugin.DefaultDialog;
import jp.sourceforge.jeextension.styleeditor.core.ColorManager;
import jp.sourceforge.jeextension.styleeditor.core.EditorTools;
import jp.sourceforge.jeextension.styleeditor.preferences.AddExtensionDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

class ExtensionEntryDialog
extends DefaultDialog {
    private Button fButtonAdd;
    private Button fButtonDel;
    private Button fButtonMod;
    private ColorManager fColorManager = new ColorManager();
    private Table fTable;

    ExtensionEntryDialog(Shell shell) {
        super(shell);
    }

    public boolean close() {
        this.fColorManager.dispose();
        return super.close();
    }

    public void handleEvent(Event event) {
        if (event.widget == this.fButtonAdd) {
            this.fireAddEntry();
        }
        if (event.widget == this.fButtonMod) {
            this.fireModifyEntry();
        }
        if (event.widget == this.fButtonDel) {
            this.fireDeleteEntry();
        }
    }

    private void addTableItem(String ext) {
        TableItem item = new TableItem(this.fTable, 0);
        item.setText(0, ext);
    }

    private Button createButton(Composite composite, String str) {
        Button button = new Button(composite, 0);
        button.setLayoutData((Object)new GridData(258));
        button.setText(str);
        button.addListener(13, (Listener)this);
        return button;
    }

    private TableColumn createTableColumn(Table table, String str) {
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setWidth(100);
        tableColumn.setText(str);
        return tableColumn;
    }

    private void fireAddEntry() {
        String[] container = new String[1];
        AddExtensionDialog d = new AddExtensionDialog(this.getShell(), container);
        if (d.open() == 0 && !container[0].equals("")) {
            this.addTableItem(container[0]);
        }
    }

    private void fireDeleteEntry() {
        int sel = this.fTable.getSelectionIndex();
        if (sel < 0) {
            return;
        }
        TableItem item = this.fTable.getItem(sel);
        String ext = item.getText();
        this.fTable.remove(sel);
        EditorTools.getPartitionEntryMap().remove(ext);
    }

    private void fireModifyEntry() {
        int sel = this.fTable.getSelectionIndex();
        if (sel < 0) {
            return;
        }
        TableItem item = this.fTable.getItem(sel);
        String ext = item.getText();
        String[] container = new String[]{ext};
        AddExtensionDialog d = new AddExtensionDialog(this.getShell(), container);
        if (d.open() == 0) {
            item.setText(0, container[0]);
        }
    }

    private void refleshTableEntry() {
        this.fTable.removeAll();
        Map map = EditorTools.getPartitionEntryMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            this.addTableItem((String)iterator.next());
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.fTable = new Table(composite, 67584);
        GridData gridData = new GridData(1808);
        gridData.verticalSpan = 5;
        this.fTable.setLayoutData((Object)gridData);
        this.fTable.setLinesVisible(true);
        this.fTable.setHeaderVisible(true);
        this.createTableColumn(this.fTable, this.getMessage("pref.com.colmn.ext"));
        this.fButtonAdd = this.createButton(composite, this.getMessage("pref.com.btn.add"));
        this.fButtonMod = this.createButton(composite, this.getMessage("pref.com.btn.mod"));
        this.fButtonDel = this.createButton(composite, this.getMessage("pref.com.btn.del"));
        this.refleshTableEntry();
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

