/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.preferences;

import java.util.Iterator;
import jp.sourceforge.jeextension.common.plugin.DefaultPreferencePage;
import jp.sourceforge.jeextension.common.xml.XMLFile;
import jp.sourceforge.jeextension.styleeditor.StyleEditorPlugin;
import jp.sourceforge.jeextension.styleeditor.core.ColorManager;
import jp.sourceforge.jeextension.styleeditor.core.EditorTools;
import jp.sourceforge.jeextension.styleeditor.entry.DefinedStyleEntry;
import jp.sourceforge.jeextension.styleeditor.entry.DependsEntryList;
import jp.sourceforge.jeextension.styleeditor.entry.IDependsEntry;
import jp.sourceforge.jeextension.styleeditor.entry.IPartitionEntry;
import jp.sourceforge.jeextension.styleeditor.entry.PartitionEntryList;
import jp.sourceforge.jeextension.styleeditor.preferences.AddDependsDialog;
import jp.sourceforge.jeextension.styleeditor.preferences.ExtensionEntryDialog;
import jp.sourceforge.jeextension.styleeditor.preferences.PartitionEntryDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;

public class StyleEditorPreferencePage
extends DefaultPreferencePage {
    private Button fButtonAdd;
    private Button fButtonDel;
    private Button fButtonDn;
    private Button fButtonExport;
    private Button fButtonImport;
    private Button fButtonMod;
    private Button fButtonExt;
    private Button fButtonPrt;
    private Button fButtonUp;
    private ColorManager fColorManager = new ColorManager();
    private Combo fComboPrt;
    private Combo fComboExt;
    private Table fTable;

    public StyleEditorPreferencePage() {
        this.setTitle(this.getMessage("pref.title"));
        this.setDescription(this.getMessage("pref.description"));
    }

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        container.setLayout((Layout)gridLayout);
        Label label = new Label(container, 0);
        label.setText(this.getMessage("pref.main.extension.label"));
        Combo combo = new Combo(container, 8);
        combo.setLayoutData((Object)new GridData(768));
        combo.addListener(13, (Listener)this);
        this.fComboExt = combo;
        Button button = new Button(container, 0);
        button.setText(this.getMessage("pref.main.extension.edit"));
        button.addListener(13, (Listener)this);
        this.fButtonExt = button;
        label = new Label(container, 0);
        label.setText(this.getMessage("pref.main.partition.label"));
        combo = new Combo(container, 8);
        combo.setLayoutData((Object)new GridData(768));
        combo.addListener(13, (Listener)this);
        this.fComboPrt = combo;
        button = new Button(container, 0);
        button.setText(this.getMessage("pref.main.partition.edit"));
        button.addListener(13, (Listener)this);
        this.fButtonPrt = button;
        Composite composite = new Composite(container, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        composite.setLayout((Layout)gridLayout2);
        Table table = new Table(composite, 67584);
        GridData gridData2 = new GridData(1808);
        gridData2.verticalSpan = 5;
        table.setLayoutData((Object)gridData2);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.createTableColumn(table, this.getMessage("pref.com.colmn.type"));
        this.createTableColumn(table, this.getMessage("pref.com.colmn.rule"));
        this.fTable = table;
        this.fButtonAdd = this.createButtonA(composite, this.getMessage("pref.com.btn.add"));
        this.fButtonMod = this.createButtonA(composite, this.getMessage("pref.com.btn.mod"));
        this.fButtonDel = this.createButtonA(composite, this.getMessage("pref.com.btn.del"));
        this.fButtonUp = this.createButtonA(composite, this.getMessage("pref.com.btn.up"));
        this.fButtonDn = this.createButtonA(composite, this.getMessage("pref.com.btn.dn"));
        Composite subComposite = new Composite(composite, 0);
        GridData gridData3 = new GridData(144);
        gridData3.horizontalSpan = 2;
        subComposite.setLayoutData((Object)gridData3);
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.numColumns = 2;
        subComposite.setLayout((Layout)gridLayout3);
        this.fButtonImport = this.createButtonB(subComposite, this.getMessage("pref.import"));
        this.fButtonExport = this.createButtonB(subComposite, this.getMessage("pref.export"));
        return container;
    }

    public void dispose() {
        this.fColorManager.dispose();
        super.dispose();
    }

    public void handleEvent(Event event) {
        if (event.widget == this.fComboExt) {
            this.refleshComboPrt();
            this.refleshTableEntry();
        }
        if (event.widget == this.fComboPrt) {
            this.refleshTableEntry();
        }
        if (event.widget == this.fButtonPrt) {
            this.showDisplayPartDlg();
        }
        if (event.widget == this.fButtonExt) {
            this.showDisplayExtDlg();
        }
        if (event.widget == this.fButtonAdd) {
            this.fireAddEntry();
        }
        if (event.widget == this.fButtonMod) {
            this.fireModifyEntry();
        }
        if (event.widget == this.fButtonDel) {
            this.fireDeleteEntry();
        }
        if (event.widget == this.fButtonUp) {
            this.fireMoveUpEntry();
        }
        if (event.widget == this.fButtonDn) {
            this.fireMoveDownEntry();
        }
        if (event.widget == this.fButtonImport) {
            this.fireImport();
        }
        if (event.widget == this.fButtonExport) {
            this.fireExport();
        }
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        StyleEditorPlugin.save();
        return super.performOk();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.refleshComboEntry();
        this.refleshTableEntry();
    }

    private void addTableItem(IDependsEntry entry) {
        TableItem item = new TableItem(this.fTable, 0);
        item.setText(0, entry.getName());
        if (entry.getName().equals("endOfLine")) {
            item.setText(1, entry.getRule().getWords()[0]);
        }
        if (entry.getName().equals("singleLine")) {
            item.setText(1, String.valueOf(entry.getRule().getWords()[0]) + " " + entry.getRule().getWords()[1]);
        }
        if (entry.getName().equals("multiLine")) {
            item.setText(1, String.valueOf(entry.getRule().getWords()[0]) + " " + entry.getRule().getWords()[1]);
        }
        if (entry.getName().equals("keyword")) {
            item.setText(1, entry.getRule().getWords()[0]);
        }
        item.setData((Object)entry);
        item.setForeground(this.fColorManager.getColor(entry.getRGB()));
    }

    private Button createButtonA(Composite composite, String str) {
        Button button = new Button(composite, 0);
        button.setLayoutData((Object)new GridData(258));
        button.setText(str);
        button.addListener(13, (Listener)this);
        return button;
    }

    private Button createButtonB(Composite composite, String str) {
        Button button = new Button(composite, 0);
        button.setLayoutData((Object)new GridData(128));
        button.setText(str);
        button.addListener(13, (Listener)this);
        return button;
    }

    private TableColumn createTableColumn(Table table, String str) {
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setWidth(100);
        tableColumn.setText(str);
        return tableColumn;
    }

    private void fireAddEntry() {
        IDependsEntry[] container = new IDependsEntry[1];
        String partName = this.fComboPrt.getItem(this.fComboPrt.getSelectionIndex());
        String extName = this.fComboExt.getItem(this.fComboExt.getSelectionIndex());
        AddDependsDialog d = new AddDependsDialog(this.getShell(), container, partName, extName);
        if (d.open() == 0) {
            this.addTableItem(container[0]);
            DefinedStyleEntry styleEntry = StyleEditorPlugin.getDefinedStyleEntry();
            styleEntry.add(container[0], extName);
        }
    }

    private void fireDeleteEntry() {
        int sel = this.fTable.getSelectionIndex();
        if (sel < 0) {
            return;
        }
        TableItem item = this.fTable.getItem(sel);
        IDependsEntry entry = (IDependsEntry)item.getData();
        this.fTable.remove(sel);
        String extName = this.fComboExt.getItem(this.fComboExt.getSelectionIndex());
        StyleEditorPlugin.getDefinedStyleEntry().remove(entry, extName);
    }

    private void fireExport() {
        FileDialog d = new FileDialog(this.getShell(), 8192);
        d.setText(this.getMessage("pref.export.message"));
        d.setFilterExtensions(new String[]{this.getMessage("pref.export.extension")});
        d.setFileName(this.getMessage("pref.export.filename"));
        String path = d.open();
        if (path == null) {
            return;
        }
        StyleEditorPlugin.save(new XMLFile(path));
        this.refleshTableEntry();
    }

    private void fireImport() {
        FileDialog d = new FileDialog(this.getShell());
        d.setText(this.getMessage("pref.import.message"));
        d.setFilterExtensions(new String[]{this.getMessage("pref.import.extension")});
        String path = d.open();
        if (path == null) {
            return;
        }
        StyleEditorPlugin.load(new XMLFile(path));
        this.refleshTableEntry();
    }

    private void fireModifyEntry() {
        int sel = this.fTable.getSelectionIndex();
        if (sel < 0) {
            return;
        }
        TableItem item = this.fTable.getItem(sel);
        IDependsEntry entry = (IDependsEntry)item.getData();
        IDependsEntry[] container = new IDependsEntry[]{entry};
        String partName = this.fComboPrt.getItem(this.fComboPrt.getSelectionIndex());
        String extName = this.fComboExt.getItem(this.fComboExt.getSelectionIndex());
        AddDependsDialog d = new AddDependsDialog(this.getShell(), container, partName, extName);
        if (d.open() == 0) {
            item.setText(0, entry.getName());
            if (entry.getName().equals("endOfLine")) {
                item.setText(1, entry.getRule().getWords()[0]);
            }
            if (entry.getName().equals("singleLine")) {
                item.setText(1, String.valueOf(entry.getRule().getWords()[0]) + " " + entry.getRule().getWords()[1]);
            }
            if (entry.getName().equals("keyword")) {
                item.setText(1, entry.getRule().getWords()[0]);
            }
            item.setData((Object)entry);
            item.setForeground(this.fColorManager.getColor(entry.getRGB()));
        }
    }

    private void fireMoveDownEntry() {
        this.fireMoveEntry(1);
    }

    private void fireMoveUpEntry() {
        this.fireMoveEntry(-1);
    }

    private void fireMoveEntry(int increment) {
        int sel = this.fTable.getSelectionIndex();
        if (sel < 0) {
            return;
        }
        Object obj = this.fTable.getSelection()[0].getData();
        String partName = this.fComboPrt.getItem(this.fComboPrt.getSelectionIndex());
        String extName = this.fComboExt.getItem(this.fComboExt.getSelectionIndex());
        IPartitionEntry partEntry = EditorTools.getPartitionEntry(partName, extName, false);
        DependsEntryList list = partEntry.getDependsEntryList();
        int index = list.indexOf(obj);
        Object removeObj = list.remove(index);
        list.add(index + increment, removeObj);
        this.refleshTableEntry();
        this.fTable.setSelection(sel + increment);
        this.refleshButtonEnable();
    }

    private void refleshButtonEnable() {
        int sel = this.fTable.getSelectionIndex();
        if (this.fTable.getItemCount() == 1) {
            this.fButtonUp.setEnabled(false);
            this.fButtonDn.setEnabled(false);
        } else if (sel == 0) {
            this.fButtonUp.setEnabled(false);
            this.fButtonDn.setEnabled(true);
        } else if (sel == this.fTable.getItemCount() - 1) {
            this.fButtonUp.setEnabled(true);
            this.fButtonDn.setEnabled(false);
        } else {
            this.fButtonUp.setEnabled(true);
            this.fButtonDn.setEnabled(true);
        }
    }

    private void refleshComboEntry() {
        this.refleshComboExt();
        this.refleshComboPrt();
    }

    private void refleshComboExt() {
        this.fComboExt.removeAll();
        Iterator iterator = EditorTools.getPartitionEntryMap().keySet().iterator();
        while (iterator.hasNext()) {
            String extName = (String)iterator.next();
            this.fComboExt.add(extName);
        }
        this.fComboExt.select(0);
    }

    private void refleshComboPrt() {
        this.fComboPrt.removeAll();
        String extName = this.fComboExt.getItem(this.fComboExt.getSelectionIndex());
        PartitionEntryList list = EditorTools.getPartitionEntryList(extName, false);
        int i = 0;
        while (i < list.size()) {
            IPartitionEntry entry = list.getPartitionEntry(i);
            this.fComboPrt.add(entry.getName());
            ++i;
        }
        this.fComboPrt.select(0);
    }

    private void refleshTableEntry() {
        this.fTable.removeAll();
        if (this.fComboPrt.getItems().length == 0) {
            return;
        }
        String partName = this.fComboPrt.getItem(this.fComboPrt.getSelectionIndex());
        String extName = this.fComboExt.getItem(this.fComboExt.getSelectionIndex());
        IPartitionEntry partEntry = EditorTools.getPartitionEntry(partName, extName, false);
        DependsEntryList entryList = partEntry.getDependsEntryList();
        int i = 0;
        while (i < entryList.size()) {
            IDependsEntry entry = entryList.getDependsEntry(i);
            this.addTableItem(entry);
            ++i;
        }
    }

    private void showDisplayPartDlg() {
        String extName = this.fComboExt.getItem(this.fComboExt.getSelectionIndex());
        PartitionEntryDialog d = new PartitionEntryDialog(this.getShell(), extName);
        d.open();
        this.refleshComboPrt();
        this.refleshTableEntry();
    }

    private void showDisplayExtDlg() {
        ExtensionEntryDialog d = new ExtensionEntryDialog(this.getShell());
        d.open();
        this.refleshComboEntry();
        this.refleshTableEntry();
    }

    protected void performDefaults() {
        StyleEditorPlugin.loadDefault();
        this.refleshComboEntry();
        this.refleshTableEntry();
    }
}

