/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.text;

import java.util.Iterator;
import java.util.Map;
import jp.sourceforge.jeextension.styleeditor.core.ColorManager;
import jp.sourceforge.jeextension.styleeditor.text.IColorActivator;
import jp.sourceforge.jeextension.styleeditor.text.IExtRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.WordRule;

public class ExtWordRule
extends WordRule
implements IExtRule {
    private String fWord;
    private String fCase;

    public ExtWordRule(IWordDetector detector) {
        super(detector);
    }

    public ExtWordRule(IWordDetector detector, IToken defaultToken) {
        super(detector, defaultToken);
    }

    public void activateColor(ColorManager cm) {
        Object obj = this.fDefaultToken.getData();
        if (obj instanceof IColorActivator) {
            ((IColorActivator)obj).activateColor(cm);
        }
        Iterator iterator = this.fWords.values().iterator();
        while (iterator.hasNext()) {
            IToken token = (IToken)iterator.next();
            obj = token.getData();
            if (!(obj instanceof IColorActivator)) continue;
            ((IColorActivator)obj).activateColor(cm);
        }
    }

    public void addWord(String word, IToken token, String sensitive) {
        super.addWord(word, token);
        this.fWord = word;
        this.fCase = sensitive;
        if (this.fCase.equalsIgnoreCase("false")) {
            String upper = word.toUpperCase();
            String lower = word.toLowerCase();
            this.addWord(upper, token);
            this.addWord(lower, token);
        }
    }

    public void addWordRuleMap(Map wordRuleMap) {
        this.fWords.putAll(wordRuleMap);
    }

    public Map getWordRuleMap() {
        return this.fWords;
    }

    public String[] getWords() {
        return new String[]{this.fWord, this.fCase};
    }

    public void setWords(String[] words) {
        String keyword = words[0];
        String casesesitive = words[1];
        IToken token = (IToken)this.fWords.remove(keyword);
        this.addWord(keyword, token, casesesitive);
    }
}

